# Patient-Novak-Petr - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Patient-Novak-Petr**

## Example Patient: Patient-Novak-Petr

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)

-------

| | |
| :--- | :--- |
| Other Id: | `https://ncez.mzcr.cz/fhir/sid/rcis`/8506150015 (use: official, ) |
| Contact Detail | * [+420777111222](tel:+420777111222)
* [+420333111777](tel:+420333111777)
* [novak@example.com](mailto:novak@example.com)
* Pavlovova 1424/11, 568 02 Svitavy - Předměstí(home)
 |
| Languages: | * Czech (preferred)
* English
 |
| Matka: | * Alena Nováková 
* Krátká 18, 708 00, Ostrava, Česká Republika(home)
* [+420601111111](tel:+420601111111)
 |
| přítel/přítelkyně: | * Alena Dlouhá 
* Horná ulica 18, 123 45, Trenčín, Slovensko(home)
* [+420601333333](tel:+420601333333)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "3f85726c-ad2f-441b-89ce-100000000000",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
      "value" : "8506150015"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "1597778923"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Novák",
      "given" : ["Petr"],
      "prefix" : ["Ing."],
      "suffix" : ["Ph.D."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420777111222",
      "use" : "home"
    },
    {
      "system" : "phone",
      "value" : "+420333111777",
      "use" : "mobile"
    },
    {
      "system" : "email",
      "value" : "novak@example.com",
      "use" : "home"
    }
  ],
  "gender" : "male",
  "birthDate" : "1985-06-15",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Pavlovova 1424/11, 568 02 Svitavy - Předměstí",
      "line" : ["Pavlovova 1424/11"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Pavlovova"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "1424/11"
            }
          ]
        }
      ],
      "city" : "Svitavy - Předměstí",
      "postalCode" : "56802",
      "country" : "CZ"
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "MTH",
              "display" : "Matka"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N",
              "display" : "příbuzný"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Nováková",
        "given" : ["Alena"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+420601111111",
          "use" : "home"
        }
      ],
      "address" : {
        "use" : "home",
        "type" : "physical",
        "text" : "Krátká 18, 708 00, Ostrava, Česká Republika",
        "line" : ["Krátká 18"],
        "_line" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                "valueString" : "Krátká"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                "valueString" : "18"
              }
            ]
          }
        ],
        "city" : "Ostrava",
        "postalCode" : "70800",
        "country" : "CZ"
      }
    },
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "FRND",
              "display" : "přítel/přítelkyně"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N",
              "display" : "příbuzný"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Dlouhá",
        "given" : ["Alena"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+420601333333",
          "use" : "home"
        }
      ],
      "address" : {
        "use" : "home",
        "type" : "physical",
        "text" : "Horná ulica 18, 123 45, Trenčín, Slovensko",
        "line" : ["Horná ulica 18"],
        "_line" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                "valueString" : "Horná ulica"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                "valueString" : "18"
              }
            ]
          }
        ],
        "city" : "Trenčín",
        "postalCode" : "12345",
        "country" : "SK"
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en"
          }
        ]
      }
    }
  ]
}

```
