# Organization-1 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Organization-1**

## Example Organization: Organization-1

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/krpzs`/27520536

**name**: Nemocnice Chrudim

**telecom**: [+420603853227](tel:+420603853227)

**address**: Václavská 570, 537 01, Chrudim(work)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/krpzs",
      "value" : "27520536"
    }
  ],
  "name" : "Nemocnice Chrudim",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420603853227",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "both",
      "text" : "Václavská 570, 537 01, Chrudim",
      "line" : ["Václavská 570"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Václavská"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "570"
            }
          ]
        }
      ],
      "city" : "Chrudim",
      "postalCode" : "53701",
      "country" : "Česká republika",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ]
}

```
