# Infekční kontakt - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Infekční kontakt**

## Example Observation: Infekční kontakt

Profile: [Observation: Infectious Contact (HDR CZ)](StructureDefinition-cz-observation-infectious-contact-hdr.md)

**status**: Final

**category**: acquisition exposure

**code**: ExposureAgent

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2024-03-25

**performer**: [Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a)

**value**: COVID-19, virus identified

**note**: 

> 

Kontakt proběhl během společné domácnosti 5 dní před příjmem.




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "Observation-InfectiousContact",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-infectious-contact-hdr"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
          "code" : "AEXPOS",
          "display" : "acquisition exposure"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
        "code" : "EXPAGNT",
        "display" : "ExposureAgent"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectiveDateTime" : "2024-03-25",
  "performer" : [
    {
      "reference" : "urn:uuid:a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "U07.1",
        "display" : "COVID-19, virus identified"
      }
    ]
  },
  "note" : [
    {
      "text" : "Kontakt proběhl během společné domácnosti 5 dní před příjmem."
    }
  ]
}

```
