# ExampleChestCircumference - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ExampleChestCircumference**

## Example Observation: ExampleChestCircumference

Profile: [Observation: Anthropometric Data (HDR CZ) - Chest Circumference](StructureDefinition-cz-observation-chestCircumference-hdr.md)

**status**: Final

**category**: Vital Signs

**code**: Waist Circumference at umbilicus by Tape measure

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2024-03-28

**performer**: [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md)

**value**: 85 cm(Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-chestCircumference-hdr"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8280-0",
        "display" : "Waist Circumference at umbilicus by Tape measure"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectiveDateTime" : "2024-03-28",
  "performer" : [
    {
      "reference" : "Practitioner/Practitioner-2"
    }
  ],
  "valueQuantity" : {
    "value" : 85,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
