# ExampleSdohAlcoholSporadic - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ExampleSdohAlcoholSporadic**

## Example Observation: ExampleSdohAlcoholSporadic

Profile: [Observation: SDOH (HDR CZ)](StructureDefinition-cz-observation-sdoh-hdr.md)

**status**: Final

**category**: Social History

**code**: Alcohol consumption

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2025-03-01 00:00:00+0100

**performer**: [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md)

**value**: Finding relating to alcohol drinking behavior

**note**: 

> 

Konzumace cca 1–2 piva týdně. Zadáno praktickým lékařem.




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "3f85726c-ad2f-441b-89ce-10000000001d",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "160573003",
        "display" : "Alcohol consumption"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectiveDateTime" : "2025-03-01T00:00:00+01:00",
  "performer" : [
    {
      "reference" : "Practitioner/Practitioner-2"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "228273003",
        "display" : "Finding relating to alcohol drinking behavior"
      }
    ]
  },
  "note" : [
    {
      "text" : "Konzumace cca 1–2 piva týdně. Zadáno praktickým lékařem."
    }
  ]
}

```
