# Medication – Paracetamol - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Medication – Paracetamol**

## Example Medication: Medication – Paracetamol

Profile: [Medication (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)

**identifier**: `https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs`/0243131

**code**: PARACETAMOL ZENTIVA K.S. 500 mg

**status**: Active

**form**: Tableta

**amount**: 500 mg(Details: UCUM code/mg = '/mg')/1 Tableta

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Item[x]** | **Strength** |
| * | PARACETAMOL | 500 mg(Details: UCUM code/mg = '/mg')/1 tableta |



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "med-paracetamol",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
  },
  "identifier" : [
    {
      "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs",
      "value" : "0243131"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs",
        "code" : "0253304",
        "display" : "PARACETAMOL ZENTIVA K.S."
      },
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpatc-cs",
        "code" : "N02BE01",
        "display" : "Paracetamol"
      }
    ],
    "text" : "PARACETAMOL ZENTIVA K.S. 500 mg"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpformy-cs",
        "code" : "TBL_FLM",
        "display" : "Potahovaná tableta"
      }
    ],
    "text" : "Tableta"
  },
  "amount" : {
    "numerator" : {
      "value" : 500,
      "unit" : "mg",
      "system" : "http://unitsofmeasure.org",
      "code" : "/mg"
    },
    "denominator" : {
      "value" : 1,
      "unit" : "Tableta"
    }
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivelatky-cs",
            "code" : "1064",
            "display" : "PARACETAMOLUM"
          }
        ],
        "text" : "PARACETAMOL"
      },
      "strength" : {
        "numerator" : {
          "value" : 500,
          "unit" : "mg",
          "system" : "http://unitsofmeasure.org",
          "code" : "/mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "tableta"
        }
      }
    }
  ]
}

```
