# Medication – Ibalgin 400 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Medication – Ibalgin 400**

## Example Medication: Medication – Ibalgin 400

Profile: [Medication (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)

**identifier**: `https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs`/0207893

**code**: Ibalgin 400 mg

**status**: Active

**form**: Tableta

**amount**: 400 mg(Details: UCUM code/mg = '/mg')/1 Tableta

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Item[x]** | **Strength** |
| * | IBUPROFEN | 400 mg(Details: UCUM code/mg = '/mg')/1 tableta |



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "med-Ibalgin400",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
  },
  "identifier" : [
    {
      "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs",
      "value" : "0207893"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs",
        "code" : "0254294",
        "display" : "IBALGIN"
      },
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpatc-cs",
        "code" : "M01AE01",
        "display" : "IBUPROFEN"
      }
    ],
    "text" : "Ibalgin 400 mg"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpformy-cs",
        "code" : "TBL_FLM",
        "display" : "Potahovaná tableta"
      }
    ],
    "text" : "Tableta"
  },
  "amount" : {
    "numerator" : {
      "value" : 400,
      "unit" : "mg",
      "system" : "http://unitsofmeasure.org",
      "code" : "/mg"
    },
    "denominator" : {
      "value" : 1,
      "unit" : "Tableta"
    }
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivelatky-cs",
            "code" : "1593",
            "display" : "IBUPROFENUM"
          }
        ],
        "text" : "IBUPROFEN"
      },
      "strength" : {
        "numerator" : {
          "value" : 400,
          "unit" : "mg",
          "system" : "http://unitsofmeasure.org",
          "code" : "/mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "tableta"
        }
      }
    }
  ]
}

```
