# Immunization recommendation example - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Immunization recommendation example**

## Example ImmunizationRecommendation: Immunization recommendation example

Profile: [ImmunizationRecommendation (CZ HDR)](StructureDefinition-cz-immunizationRecommendation-hdr.md)

**patient**: [Mračena Mrakomorová (no stated gender), DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rid#4567891235)](Patient-Mracena.md)

**date**: 2025-03-07

> **recommendation****vaccineCode**:Severe acute respiratory syndrome coronavirus 2 mRNA only vaccine product**targetDisease**:Disease caused by 2019 novel coronavirus**forecastStatus**:Due

### DateCriterions

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value** |
| * | Earliest date to give | 2025-03-14 |




## Resource Content

```json
{
  "resourceType" : "ImmunizationRecommendation",
  "id" : "ImmunizationRecommendation",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr"
    ]
  },
  "patient" : {
    "reference" : "Patient/Mracena"
  },
  "date" : "2025-03-07",
  "recommendation" : [
    {
      "vaccineCode" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1119349007"
            }
          ]
        }
      ],
      "targetDisease" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "840539006"
          }
        ]
      },
      "forecastStatus" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/immunization-recommendation-status",
            "code" : "due"
          }
        ]
      },
      "dateCriterion" : [
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "30981-5"
              }
            ]
          },
          "value" : "2025-03-14"
        }
      ]
    }
  ]
}

```
