# Očkování Covid - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Očkování Covid**

## Example Immunization: Očkování Covid

Profile: [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md)

> **Immunization AdministeredProduct**
* reference: [Medication COMIRNATY OMICRON XBB.1.5](Medication-med-CovidVaccineComirnaty.md)

**status**: Completed

**vaccineCode**: SARS-CoV-2 vaccine

**patient**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Patient-3f85726c-ad2f-441b-89ce-100000000000.md)

**occurrence**: 2021-05-05

**primarySource**: true

**manufacturer**: [Organization Pfizer s.r.o.](Organization-Organization-Pfizer.md)

**note**: 

> 

Pacient dostal druhou dávku vakcíny Comirnaty.


### ProtocolApplieds

| | | |
| :--- | :--- | :--- |
| - | **TargetDisease** | **DoseNumber[x]** |
| * | COVID-19 | 2 |



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "Immunization-CovidExample",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "reference",
          "valueReference" : {
            "reference" : "Medication/med-CovidVaccineComirnaty"
          }
        }
      ],
      "url" : "http://hl7.eu/fhir/hdr/StructureDefinition/immunization-administeredProduct"
    }
  ],
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "28531000087107",
        "display" : "SARS-CoV-2 vaccine"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/3f85726c-ad2f-441b-89ce-100000000000"
  },
  "occurrenceDateTime" : "2021-05-05",
  "primarySource" : true,
  "manufacturer" : {
    "reference" : "Organization/Organization-Pfizer"
  },
  "note" : [
    {
      "text" : "Pacient dostal druhou dávku vakcíny Comirnaty."
    }
  ],
  "protocolApplied" : [
    {
      "targetDisease" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "840539006",
              "display" : "COVID-19"
            }
          ]
        }
      ],
      "doseNumberPositiveInt" : 2
    }
  ]
}

```
