# CZ-Encounter-HDR Example - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Encounter-HDR Example**

## Example Encounter: CZ-Encounter-HDR Example

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**org/fhir/StructureDefinition/legalStatus**: Legal

**status**: finished

**class**: [ActCode: IMP](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**priority**: Emergency

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

### Participants

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Individual** |
| * | Admitter | [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md) |

**period**: 2025-01-01 08:00:00+0100 --> 2025-01-10 08:00:00+0100

**reasonCode**: Heart failure

### Diagnoses

| | | |
| :--- | :--- | :--- |
| - | **Condition** | **Use** |
| * | [Condition Heart failure](Condition-CZ-Condition-HDR-Example.md) | Admission diagnosis |

### Hospitalizations

| | | |
| :--- | :--- | :--- |
| - | **AdmitSource** | **DischargeDisposition** |
| * | Medical Practitioner/physician referral | Home |

> **location****location**:[Location Nemocnice Praha - Oddělení A](Location-sample-cz-location-2.md)**period**: 2025-01-01 08:00:00+0100 --> 2025-01-03 08:00:00+0100

> **location****location**:[Location Nemocnice Praha - Oddělení B](Location-sample-cz-location-3.md)**period**: 2025-01-03 08:00:00+0100 --> 2025-01-07 08:00:00+0100

> **location****location**:[Location Nemocnice Praha - Oddělení C](Location-sample-cz-location-4.md)**period**: 2025-01-07 08:00:00+0100 --> 2025-01-10 08:00:00+0100

**serviceProvider**: [Organization MUDr. Jana Krásná](Organization-RegisteringProviderExample.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "CZ-Encounter-HDR-Example",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
    ]
  },
  "extension" : [
    {
      "url" : "http://example.org/fhir/StructureDefinition/legalStatus",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "398165009",
            "display" : "Legal"
          }
        ]
      }
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActPriority",
        "code" : "EM",
        "display" : "Emergency"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Mracena2"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ADM",
              "display" : "Admitter"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "Practitioner/Practitioner-2"
      }
    }
  ],
  "period" : {
    "start" : "2025-01-01T08:00:00+01:00",
    "end" : "2025-01-10T08:00:00+01:00"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/sid/icd-10",
          "code" : "I50",
          "display" : "Heart failure"
        }
      ]
    }
  ],
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/CZ-Condition-HDR-Example"
      },
      "use" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/diagnosis-role",
            "code" : "AD",
            "display" : "Admission diagnosis"
          }
        ]
      }
    }
  ],
  "hospitalization" : {
    "admitSource" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/admit-source",
          "code" : "mp",
          "display" : "Medical Practitioner/physician referral"
        }
      ]
    },
    "dischargeDisposition" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/discharge-disposition",
          "code" : "home",
          "display" : "Home"
        }
      ]
    }
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/sample-cz-location-2"
      },
      "period" : {
        "start" : "2025-01-01T08:00:00+01:00",
        "end" : "2025-01-03T08:00:00+01:00"
      }
    },
    {
      "location" : {
        "reference" : "Location/sample-cz-location-3"
      },
      "period" : {
        "start" : "2025-01-03T08:00:00+01:00",
        "end" : "2025-01-07T08:00:00+01:00"
      }
    },
    {
      "location" : {
        "reference" : "Location/sample-cz-location-4"
      },
      "period" : {
        "start" : "2025-01-07T08:00:00+01:00",
        "end" : "2025-01-10T08:00:00+01:00"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/RegisteringProviderExample"
  }
}

```
