# CZ-Condition-HDR Varicose Veins - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Condition-HDR Varicose Veins**

## Example Condition: CZ-Condition-HDR Varicose Veins

Profile: [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Encounter Diagnosis, On admission, Did not receive therapy or drug for

**code**: Křečové žíly dolních končetin

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "VaricoseVeinsCondition",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "encounter-diagnosis"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "278307001",
          "display" : "On admission"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "25265005",
          "display" : "Did not receive therapy or drug for"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "I83.9",
        "display" : "Varicose veins of lower extremities without ulcer or inflammation"
      }
    ],
    "text" : "Křečové žíly dolních končetin"
  },
  "subject" : {
    "reference" : "Patient/Mracena2"
  }
}

```
