# eHN Subject Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Subject Model to this guide Map**

## ConceptMap: eHN Subject Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/subject2FHIR-cz-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:Subject2FHIRCzHdr |

 
eHN HDR Subject Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "subject2FHIR-cz-hdr",
  "url" : "https://hl7.cz/fhir/hdr/ConceptMap/subject2FHIR-cz-hdr",
  "version" : "0.1.0",
  "name" : "Subject2FHIRCzHdr",
  "title" : "eHN Subject Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "eHN HDR Subject Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
      "element" : [
        {
          "code" : "subjectIdentification",
          "display" : "A.1.1 - Identification of the patient/subject",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectIdentification.given",
          "display" : "A.1.1.1 - Given name",
          "target" : [
            {
              "code" : "Patient.name.given",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "subjectIdentification.family",
          "display" : "A.1.1.2 - Family name/surname",
          "target" : [
            {
              "code" : "Patient.name.family",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "subjectIdentification.birthDate",
          "display" : "A.1.1.3 - Date of birth",
          "target" : [
            {
              "code" : "Patient.birthDate",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "subjectIdentification.identifier",
          "display" : "A.1.1.4 - National healthcare patient ID",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "subjectIdentification.Citizenship",
          "display" : "A.1.1.5 - Citizenship",
          "target" : [
            {
              "code" : "Patient.extension:Citizenship.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectIdentification.gender",
          "display" : "A.1.1.6 - Gender",
          "target" : [
            {
              "code" : "Patient.gender",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "subjectIdentification.Communication",
          "display" : "A.1.1.7 - Communication - Language",
          "target" : [
            {
              "code" : "Patient.Communication",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "subjectContact",
          "display" : "A.1.2 - Patient/subject related contact information",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "subjectContact.personalContact",
          "display" : "A.1.2.1 - Patient address",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "subjectContact.personalContact.address",
          "display" : "A.1.2.1.1 - Address",
          "target" : [
            {
              "code" : "Patient.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.personalContact.telecom",
          "display" : "A.1.2.1.2 - Telecom",
          "target" : [
            {
              "code" : "Patient.telecom",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP",
          "display" : "A.1.2.2 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
          "target" : [
            {
              "code" : "Patient.generalPractitioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson",
          "display" : "A.1.2.3 - Contact person/ legal guardian (multiple contacts could be provided)",
          "target" : [
            {
              "code" : "Patient.contact",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson.role",
          "display" : "A.1.2.3.1 - Role of that person",
          "target" : [
            {
              "code" : "Patient.contact.relationship:role",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson.relationship",
          "display" : "A.1.2.3.2 - Relationship level",
          "target" : [
            {
              "code" : "Patient.contact.relationship:type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson.given",
          "display" : "A.1.2.3.4 - Given name",
          "target" : [
            {
              "code" : "Patient.contact.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson.family",
          "display" : "A.1.2.3.5 - Family name/surname",
          "target" : [
            {
              "code" : "Patient.contact.name.family",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson.address",
          "display" : "A.1.2.3.6 - Address",
          "target" : [
            {
              "code" : "Patient.contact.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson.telecom",
          "display" : "A.1.2.3.7 - Telecom",
          "target" : [
            {
              "code" : "Patient.contact.telecom",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.contactPerson.organization",
          "display" : "A.1.2.3.8 - Contact person organisation",
          "target" : [
            {
              "code" : "Patient.contact",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
      "element" : [
        {
          "code" : "subjectContact.preferredHP",
          "display" : "A.1.2.2 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
          "target" : [
            {
              "code" : "Practictioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.identifier",
          "display" : "A.1.2.2.1 - Identifier of the HP",
          "target" : [
            {
              "code" : "Practictioner.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.name",
          "display" : "A.1.2.2.2 - Name of the HP",
          "target" : [
            {
              "code" : "Practictioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.address",
          "display" : "A.1.2.2.5 - Address",
          "target" : [
            {
              "code" : "Practictioner.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.telecom",
          "display" : "A.1.2.2.6 - Telecom",
          "target" : [
            {
              "code" : "Practictioner.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "subjectContact.preferredHP",
          "display" : "A.1.2.2 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
          "target" : [
            {
              "code" : "PractictionerRole",
              "equivalence" : "equivalent",
              "comment" : "preferred"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.identifier",
          "display" : "A.1.2.2.1 - Identifier of the HP",
          "target" : [
            {
              "code" : "PractictionerRole.identifier",
              "equivalence" : "equivalent",
              "comment" : "preferred"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.name",
          "display" : "A.1.2.2.2 - Name of the HP",
          "target" : [
            {
              "code" : "PractictionerRole.practictioner.name",
              "equivalence" : "equivalent",
              "comment" : "preferred"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.role",
          "display" : "A.1.2.2.3 - Role of the HP",
          "target" : [
            {
              "code" : "PractictionerRole.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.organization",
          "display" : "A.1.2.2.4 - HP Organisation",
          "target" : [
            {
              "code" : "PractictionerRole.organization",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.address",
          "display" : "A.1.2.2.5 - Address",
          "target" : [
            {
              "code" : "PractictionerRole.address",
              "equivalence" : "relatedto",
              "comment" : "preferred"
            }
          ]
        },
        {
          "code" : "subjectContact.preferredHP.telecom",
          "display" : "A.1.2.2.6 - Telecom",
          "target" : [
            {
              "code" : "PractictionerRole.telecom",
              "equivalence" : "relatedto",
              "comment" : "preferred"
            }
          ]
        }
      ]
    }
  ]
}

```
