# eHN Objective Findings Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Objective Findings Model to this guide Map**

## ConceptMap: eHN Objective Findings Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/objectiveFindings2FHIR-hdr-cz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:ObjectiveFindings2FHIREuHdr |

 
eHN HDR Objective Findings Model to this guide Map 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "objectiveFindings2FHIR-hdr-cz",
  "url" : "https://hl7.cz/fhir/hdr/ConceptMap/objectiveFindings2FHIR-hdr-cz",
  "version" : "0.1.0",
  "name" : "ObjectiveFindings2FHIREuHdr",
  "title" : "eHN Objective Findings Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "eHN HDR Objective Findings Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogCzObjectiveFindingsCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr",
      "element" : [
        {
          "code" : "ObjectiveFindings.anthropometricObservations",
          "display" : "A.2.8.1.3 - Anthropometric observations",
          "target" : [
            {
              "code" : "Composition.section",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.vitalSigns",
          "display" : "A.2.8.1.4 - Vital signs",
          "target" : [
            {
              "code" : "Composition.section:sectionVitalSigns",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.physicalExamination",
          "display" : "A.2.8.1.5 - Physical examination",
          "target" : [
            {
              "code" : "Composition.section:sectionPhysicalExamination",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.physicalExamination.description",
          "display" : "A.2.8.1.5.1 - Observation Note",
          "target" : [
            {
              "code" : "Composition.section:sectionPhysicalExamination.text",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogCzObjectiveFindingsCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "element" : [
        {
          "code" : "ObjectiveFindings.date",
          "display" : "A.2.8.1.1 - Date",
          "target" : [
            {
              "code" : "Observation.effectiveDateTime",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogCzObjectiveFindingsCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/vitalsigns",
      "element" : [
        {
          "code" : "ObjectiveFindings.anthropometricObservations.description",
          "display" : "A.2.8.1.3.1 - Result description",
          "target" : [
            {
              "code" : "Observation.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.anthropometricObservations.details",
          "display" : "A.2.8.1.3.2 - Observation details",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.anthropometricObservations.result",
          "display" : "A.2.8.1.3.3 - Observation result",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.vitalSigns.description",
          "display" : "A.2.8.1.4.1 - Result description",
          "target" : [
            {
              "code" : "Observation.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.vitalSigns.details",
          "display" : "A.2.8.1.4.2 - Observation details",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "ObjectiveFindings.vitalSigns.result",
          "display" : "A.2.8.1.4.3 - Observation result",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    }
  ]
}

```
