# eHN Functional Status Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Functional Status Model to this guide Map**

## ConceptMap: eHN Functional Status Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/functionalStatus2FHIR-hdr-cz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:FunctionalStatus2FHIREuHdr |

 
eHN HDR Functional Status Model to this guide Map 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "functionalStatus2FHIR-hdr-cz",
  "url" : "https://hl7.cz/fhir/hdr/ConceptMap/functionalStatus2FHIR-hdr-cz",
  "version" : "0.1.0",
  "name" : "FunctionalStatus2FHIREuHdr",
  "title" : "eHN Functional Status Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "eHN HDR Functional Status Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/FunctionalStatusCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr",
      "element" : [
        {
          "code" : "FunctionalStatus.description",
          "display" : "A.2.8.2.1 - Description",
          "target" : [
            {
              "code" : "Composition.section:sectionFunctionalStatus.text",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/FunctionalStatusCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
      "element" : [
        {
          "code" : "FunctionalStatus.assessmentType",
          "display" : "A.2.8.2.3 - Functional assessment description",
          "target" : [
            {
              "code" : "ClinicalImpression.code",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "FunctionalStatus.assessmentDate",
          "display" : "A.2.8.2.4 - Functional assessment date",
          "target" : [
            {
              "code" : "ClinicalImpression.effective[x]",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "FunctionalStatus.assessmentResult",
          "display" : "A.2.8.2.5 - Functional assessment result",
          "target" : [
            {
              "code" : "ClinicalImpression.finding",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/FunctionalStatusCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr",
      "element" : [
        {
          "code" : "FunctionalStatus.description",
          "display" : "A.2.8.2.1 - Description",
          "target" : [
            {
              "code" : "Condition.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "FunctionalStatus.onsetDate",
          "display" : "A.2.8.2.2 - Onset Date",
          "target" : [
            {
              "code" : "Condition.onsetDateTime",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    }
  ]
}

```
