# CarePlan-Novak-Petr - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CarePlan-Novak-Petr**

## Example CarePlan: CarePlan-Novak-Petr

**status**: Active

**intent**: Plan

**title**: Plán péče – tříselná kýla

**description**: Plán péče zaměřený na chirurgické řešení jednostranné tříselné kýly (K40.9) u stabilního pacienta. Péče zahrnuje pooperační sledování, edukaci o režimu a následnou ambulantní kontrolu.

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**period**: 2025-03-10 08:00:00+0100 --> (ongoing)

**addresses**: [Condition Unilateral or unspecified inguinal hernia, without obstruction or gangrene](Bundle-DischargeBundle-Novak-Petr-Subsections.md#urn-uuid-35717696-8a99-4f99-a938-ec0ec88a65a2)

**goal**: [Goal: lifecycleStatus = active; description = ; start[x] = 2025-03-10](Bundle-DischargeBundle-Novak-Petr-Subsections.md#urn-uuid-620b1120-cece-44b1-89f5-20413054eb1d)

> **activity**

### Details

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Kind** | **Status** | **Description** |
| * | ServiceRequest | Scheduled | Pooperační sledování, převazy, kontrola rány |


> **activity**

### Details

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Kind** | **Status** | **Description** |
| * | CommunicationRequest | Scheduled | Edukace pacienta o režimu po operaci |


> **activity**

### Details

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Kind** | **Status** | **Description** |
| * | Appointment | Scheduled | Ambulantní kontrola za 14 dní |




## Resource Content

```json
{
  "resourceType" : "CarePlan",
  "id" : "9c913d06-84fe-4d35-b35b-8b0c7965f535",
  "status" : "active",
  "intent" : "plan",
  "title" : "Plán péče – tříselná kýla",
  "description" : "Plán péče zaměřený na chirurgické řešení jednostranné tříselné kýly (K40.9) u stabilního pacienta. Péče zahrnuje pooperační sledování, edukaci o režimu a následnou ambulantní kontrolu.",
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "period" : {
    "start" : "2025-03-10T08:00:00+01:00"
  },
  "addresses" : [
    {
      "reference" : "urn:uuid:35717696-8a99-4f99-a938-ec0ec88a65a2"
    }
  ],
  "goal" : [
    {
      "reference" : "urn:uuid:620b1120-cece-44b1-89f5-20413054eb1d"
    }
  ],
  "activity" : [
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "status" : "scheduled",
        "description" : "Pooperační sledování, převazy, kontrola rány"
      }
    },
    {
      "detail" : {
        "kind" : "CommunicationRequest",
        "status" : "scheduled",
        "description" : "Edukace pacienta o režimu po operaci"
      }
    },
    {
      "detail" : {
        "kind" : "Appointment",
        "status" : "scheduled",
        "description" : "Ambulantní kontrola za 14 dní"
      }
    }
  ]
}

```
