# AllergyIntolerance - Penicillin - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **AllergyIntolerance - Penicillin**

## Example AllergyIntolerance: AllergyIntolerance - Penicillin

Alergie na penicilin – kožní vyrážka, otok rtů.



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "PenicillinAllergy",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:oid:1.2.203.24341.1.1.999",
      "value" : "PenicillinAllergy-001"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed"
      }
    ]
  },
  "type" : "allergy",
  "criticality" : "low",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "764146007",
        "display" : "Penicillin"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/Mracena"
  },
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "271807003",
              "display" : "Eruption of skin"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "267038008",
              "display" : "Edema (finding)"
            }
          ]
        }
      ],
      "description" : "Kožní vyrážka, otok rtů."
    }
  ]
}

```
