# AllergyIntolerance - cow's milk protein - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **AllergyIntolerance - cow's milk protein**

## Example AllergyIntolerance: AllergyIntolerance - cow's milk protein

Intolerance na bílkovinu kravského mléka. Počátek období projevu: 15 let



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "MilkAllergy",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:oid:1.2.203.24341.1.1.999",
      "value" : "MilkAllergy-001"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "type" : "intolerance",
  "criticality" : "low",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "738069006"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/Mracena"
  },
  "onsetAge" : {
    "value" : 15,
    "system" : "http://unitsofmeasure.org",
    "code" : "a"
  },
  "lastOccurrence" : "2025-01-01",
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "418363000",
              "display" : "Itching of skin (finding)"
            }
          ]
        }
      ],
      "description" : "Projevy: vyrážka, svědění kůže po požití mléka."
    }
  ]
}

```
