# Home - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ImplementationGuide/hl7.fhir.cz.hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:HL7CzHospitalDischargeIg |

### Introduction

Specify a set of rules that will be used for HL7 FHIR to define how to represent hospital discahrge messages in the Czech national context, in line with European eHN guidelines.

Its main objective is to define the content components and the preferred structure to be used to construct a hospital discharge report.The purpose of this standard is to define the representation of the discharge report as a patient's medical record for the purpose of electronic exchange of health information between individuals, healthcare providers and infrastructure in the Czech Republic.

This includes both jurisdictional and cross-border scenarios.

**This guide does not describe how to exchange this message.**

### Information Models

**Fig. 1: Hospital discharge report structure**

Basic Sections of the Hospital Discharge Report

| | | | |
| :--- | :--- | :--- | :--- |
| A.1 Header with Administrative Document Data | 1..1 | Mandatory | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2 Document Content | 1..1 | Mandatory | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.1 Previously Expressed Wishes | 0..1 | Required | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.2 Urgent Information | 1..1 | Mandatory | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.3 Hospitalization Data | 1..1 | Mandatory | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.4 Reason for Admission | 0..1 | Required | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.5 Condition at Admission (Initial Examination) | 0..1 | Optional | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.6 Medical History | 0..1 | Optional | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.7 Course of Hospitalization | 1..1 | Mandatory | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.8 Condition at Discharge | 1..1 | Mandatory | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.2.9 Recommendations | 0..1 | Required | [Link](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| A.3 Presentation form | 1..1 | Mandatory | [Link] |
| A.4 Attachments | 0..1 | Optional | [Link] |

### Scope

This document presents Czech use concepts defined via FHIR processable artefacts; these are collaborative outputs with agreed approaches to varied kinds of healthcare related information based on the core FHIR R4 specification.

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for this guide.
* [Artifacts](artifacts.md): These page lists detailed descriptions and formal definitions for all the Czech HDR artifacts and logic model defined in this guide.

### Dependencies























### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.hdr.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.hdr.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AdvanceDirectives2FHIRCzHdr](ConceptMap-advanceDirectives2FHIR-cz-hdr.md), [Alerts2FHIRCzHdr](ConceptMap-alerts2FHIR-cz-hdr.md)...Show 121 more,[AttachmentHDR2FHIRcz](ConceptMap-AttachmentHDR2FHIR-cz.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md),[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-core](Bundle-DischargeBundle-Novak-Petr-L1-core.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CHIR - Oddělení chirurgie](Organization-af2b3114-e872-43b9-9875-cceb39122f7f.md),[CHIR-L2 - Lůžková stanice 2](Organization-a4641bd0-34af-4038-a7db-872d08a54df9.md),[CZConsentCategory](ValueSet-cz-consent-category.md),[CZProvisionCode](ValueSet-cz-provision-code.md),[CZ_AddressObligationsHdr](StructureDefinition-cz-address-obl-hdr.md),[CZ_AllergyIntoleranceHdr](StructureDefinition-cz-allergyIntolerance-hdr.md),[CZ_AllergyIntoleranceObligationsHdr](StructureDefinition-cz-allergyintolerance-obl-hdr.md),[CZ_AttachmentHdr](StructureDefinition-cz-attachment-hdr.md),[CZ_AttachmentsObligationsHdr](StructureDefinition-cz-attachment-obl-hdr.md),[CZ_BundleHdr](StructureDefinition-cz-bundle-hdr.md),[CZ_CarePlanHdr](StructureDefinition-cz-carePlan-hdr.md),[CZ_CompositionHdr](StructureDefinition-cz-composition-hdr.md),[CZ_CompositionObligationsHdr](StructureDefinition-cz-composition-obl-hdr.md),[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[CZ_ConsentHdr](StructureDefinition-cz-consent-hdr.md),[CZ_ConsentObligationsHdr](StructureDefinition-cz-consent-obl-hdr.md),[CZ_CoverageObligationsHdr](StructureDefinition-cz-coverage-obl-hdr.md),[CZ_DeviceUseStatementHdr](StructureDefinition-cz-deviceUseStatement-hdr.md),[CZ_DosageHospitalStayObligationsHdr](StructureDefinition-cz-dosage-hospitalstay-obl-hdr.md),[CZ_DosageMedicationSummaryObligationsHdr](StructureDefinition-cz-dosage-medicationsummary-obl-hdr.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[CZ_EncounterObligationsHdr](StructureDefinition-cz-encounter-obl-hdr.md),[CZ_FamilyMemberHistoryHdr](StructureDefinition-cz-familyMemberHistory-hdr.md),[CZ_FlagHdr](StructureDefinition-cz-flag-hdr.md),[CZ_FlagObligationsHdr](StructureDefinition-cz-flag-obl-hdr.md),[CZ_ImmunizationHdr](StructureDefinition-cz-immunization-hdr.md),[CZ_ImmunizationObligationsHdr](StructureDefinition-cz-immunization-obl-hdr.md),[CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md),[CZ_ImmunizationRecommendationObligationsHdr](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md),[CZ_MedicalDeviceObligationsHdr](StructureDefinition-cz-medicalDevice-obl-hdr.md),[CZ_MedicationAdministrationObligationsHdr](StructureDefinition-cz-medicationadministration-obl-hdr.md),[CZ_MedicationDispenseHdr](StructureDefinition-cz-medicationDispense-hdr.md),[CZ_MedicationDispenseHospitalStayObligationsHdr](StructureDefinition-cz-medicationdispens-hospitalstay-obl-hdr.md),[CZ_MedicationDispenseMedicationSummaryObligationsHdr](StructureDefinition-cz-medicationdispens-medicationsummary-obl-hdr.md),[CZ_MedicationHospitalStayObligationsHdr](StructureDefinition-cz-medication-hospitalstay-obl-hdr.md),[CZ_MedicationMedicationSummaryObligationsHdr](StructureDefinition-cz-medication-medicationsummary-obl-hdr.md),[CZ_MedicationRequestHdr](StructureDefinition-cz-medicationRequest-hdr.md),[CZ_MedicationRequestHospitalStayObligationsHdr](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md),[CZ_MedicationRequestMedicationSummaryObligationsHdr](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md),[CZ_MedicationStatementObligationsHdr](StructureDefinition-cz-medicationstatement-obl-hdr.md),[CZ_ObservationAbdominalCircumferenceHdr](StructureDefinition-cz-observation-abdominalCircumference-hdr.md),[CZ_ObservationAnthropometricDataHdrObligations](StructureDefinition-cz-observation-anthropometricdata-obl-hdr.md),[CZ_ObservationBMIHdr](StructureDefinition-cz-observation-BMI-hdr.md),[CZ_ObservationChestCircumferenceHdr](StructureDefinition-cz-observation-chestCircumference-hdr.md),[CZ_ObservationHeadCircumferenceHdr](StructureDefinition-cz-observation-headCircumference-hdr.md),[CZ_ObservationHeightHdr](StructureDefinition-cz-observation-height-hdr.md),[CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md),[CZ_ObservationInfectiousContactHdrObligations](StructureDefinition-cz-observation-ic-obl-hdr.md),[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[CZ_ObservationTravelHdr](StructureDefinition-cz-observation-travel-hdr.md),[CZ_ObservationWeightHdr](StructureDefinition-cz-observation-weight-hdr.md),[CZ_OrganizationObligationsHdr](StructureDefinition-cz-organization-obl-hdr.md),[CZ_PatientObligationsHdr](StructureDefinition-cz-patient-obl-hdr.md),[CZ_PractitionerObligationsHdr](StructureDefinition-cz-practitioner-obl-hdr.md),[CZ_PractitionerRoleObligationsHdr](StructureDefinition-cz-practitionerRole-obl-hdr.md),[CZ_ProcedureHdr](StructureDefinition-cz-procedure-hdr.md),[CZ_ProcedureObligationsHdr](StructureDefinition-cz-procedure-obl-hdr.md),[CZ_RelatedPersonHdr](StructureDefinition-cz-relatedPerson-hdr.md),[CZ_RelatedPersonObligationsHdr](StructureDefinition-cz-relatedPerson-obl-hdr.md),[EHDSIConditionPOA](ValueSet-eHDSIConditionPOA.md),[EHDSITreatmentClass](ValueSet-eHDSITreatmentClass.md),[Encounter2FHIRCzHdr](ConceptMap-encounter2FHIR-cz-hdr.md),[ExposureAgentHdrVs](ValueSet-exposureAgent-eu-hdr.md),[FunctionalStatus2FHIREuHdr](ConceptMap-functionalStatus2FHIR-hdr-cz.md),[HL7CzHospitalDischargeIg](index.md),[Hdr2FHIRCzHdr](ConceptMap-hdr2FHIR-cz-hdr.md),[Header2FHIRczHdr](ConceptMap-hdrHeader2FHIR-cz-hdr.md),[HospitalStay2FHIRCzHdr](ConceptMap-hospitalStay2FHIR-cz-hdr.md),[LogCzAdmissionEvaluation](StructureDefinition-LogAdmissionEvaluationCz.md),[LogCzAdvanceDirectivesEhnCz](StructureDefinition-LogAdvanceDirectivesCz.md),[LogCzAlertsCz](StructureDefinition-LogAlertsCz.md),[LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md),[LogCzDigitalSignatureCz](StructureDefinition-LogdigitalSignatureCz.md),[LogCzDischargeDetailsCz](StructureDefinition-LogDischargeDetailsCz.md),[LogCzEncounterCz](StructureDefinition-LogInPatientEncounterCz.md),[LogCzFunctionalStatusHdrCz](StructureDefinition-LogFunctionalStatusCz.md),[LogCzHeaderCz](StructureDefinition-LogHeaderHdrCz.md),[LogCzHospitalDischargeReportCz](StructureDefinition-LogHospitalDischargeReportCz.md),[LogCzHospitalStayCz](StructureDefinition-LogHospitalStayCz.md),[LogCzMedicationSummaryHdrCz](StructureDefinition-LogMedicationSummaryCz.md),[LogCzPatientHistoryCz](StructureDefinition-LogPatientHistoryCz.md),[LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md),[LogCzSubjectHdrCz](StructureDefinition-LogSubjectCz.md),[LogEnAdmissionEvaluationEhnEn](StructureDefinition-AdmissionEvaluationEhnEn.md),[LogEnAdvanceDirectivesEhnCz](StructureDefinition-AdvanceDirectivesCz.md),[LogEnAlertsEhnCz](StructureDefinition-AlertsCz.md),[LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md),[LogEnDigitalSignatureCz](StructureDefinition-digitalSignatureCz.md),[LogEnDischargeDetailsEhnCz](StructureDefinition-DischargeDetailsCz.md),[LogEnEncounterEhnCz](StructureDefinition-InPatientEncounterCz.md),[LogEnFunctionalStatusHdrEhnCz](StructureDefinition-FunctionalStatusCz.md),[LogEnHeaderHdrCz](StructureDefinition-Header.md),[LogEnHospitalDischargeReportEhnCz](StructureDefinition-HospitalDischargeReportCz.md),[LogEnHospitalStayEhnCz](StructureDefinition-HospitalStayCz.md),[LogEnMedicationSummaryHdrEhnCz](StructureDefinition-MedicationSummaryCz.md),[LogEnObjectiveFindingsHdrEhnCz](StructureDefinition-ObjectiveFindingsCz.md),[LogEnPatientHistoryEhnCz](StructureDefinition-PatientHistoryCz.md),[LogEnPlanOfCareHdrEhnCz](StructureDefinition-PlanOfCareCz.md),[LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md),[LogEnSubjectHdrEhnCz](StructureDefinition-SubjectCz.md),[MedicationSummary2FHIRCzHdr](ConceptMap-medicationSummary2FHIR-cz-hdr.md),[Nemocnice Chrudim](Organization-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169.md),[Nemocnice Pardubického kraje, a.s., Chrudimská nemocnice](Organization-9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1.md),[ObjectiveFindings2FHIREuHdr](ConceptMap-objectiveFindings2FHIR-hdr-cz.md),[ObjectiveFindingsHdrCz](StructureDefinition-LogCzObjectiveFindingsCz.md),[Observation/Observation-TravelHistory-Madagaskar](Observation-Observation-TravelHistory-Madagaskar.md),[PLogCzlanOfCareHdrCz](StructureDefinition-LogPlanOfCareCz.md),[Patient/48a9d440-4194-42c1-87ad-b5a39020a4d0](Patient-48a9d440-4194-42c1-87ad-b5a39020a4d0.md),[Patient/Mracena2](Patient-Mracena2.md),[PatientHistory2FHIRCzHdr](ConceptMap-patientHistory2FHIR-cz-hdr.md),[PlanOfCare2FHIRCzHdr](ConceptMap-planOfCare2FHIR-cz-hdr.md),[Practitioner/Practitioner-L1](Practitioner-Practitioner-L1.md),[RelatedPersonRelationshipTypesHDR](ValueSet-relatedPersonRelationshipTypes-eu-hdr.md),[Subject2FHIRCzHdr](ConceptMap-subject2FHIR-cz-hdr.md)and[TemporaryHDRSystem](CodeSystem-temporarySystem-hdr-cz.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [Procedure/Procedure-No-Procedure](Procedure-Procedure-No-Procedure.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/CodeSystem-v3-ucum.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 17 more,[Medication/Medication-Euthyrox](Medication-Medication-Euthyrox.md),[Medication/med-CovidVaccineComirnaty](Medication-med-CovidVaccineComirnaty.md),[Medication/med-Ibalgin400](Medication-med-Ibalgin400.md),[Medication/med-paracetamol](Medication-med-paracetamol.md),[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md),[Observation/5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md),[Observation/5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md),[Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md),[Observation/6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md),[Observation/7cf304de-5ae3-4621-8531-9c8f0b2d4e3a](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md),[Observation/8d2aea77-f576-4d0f-9508-537359aa44d6](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md),[Observation/hb-result](Observation-hb-result.md),[Observation/hct-result](Observation-hct-result.md),[Observation/plt-result](Observation-plt-result.md),[Observation/rbc-result](Observation-rbc-result.md)and[Observation/wbc-result](Observation-wbc-result.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [ASTM Signature Type Codes](http://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/CodeSystem-astm-signature-type.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 4 more,[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab.md)and[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 35 more,[Bundle/DischargeBundle-Novak-Petr-L1-core](Bundle-DischargeBundle-Novak-Petr-L1-core.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZConsentCategory](ValueSet-cz-consent-category.md),[CZ_CompositionHdr](StructureDefinition-cz-composition-hdr.md),[CZ_CompositionObligationsHdr](StructureDefinition-cz-composition-obl-hdr.md),[CZ_ConsentHdr](StructureDefinition-cz-consent-hdr.md),[CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md),[CZ_ImmunizationRecommendationObligationsHdr](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md),[CZ_ObservationAbdominalCircumferenceHdr](StructureDefinition-cz-observation-abdominalCircumference-hdr.md),[CZ_ObservationBMIHdr](StructureDefinition-cz-observation-BMI-hdr.md),[CZ_ObservationChestCircumferenceHdr](StructureDefinition-cz-observation-chestCircumference-hdr.md),[CZ_ObservationHeadCircumferenceHdr](StructureDefinition-cz-observation-headCircumference-hdr.md),[CZ_ObservationHeightHdr](StructureDefinition-cz-observation-height-hdr.md),[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[CZ_ObservationTravelHdr](StructureDefinition-cz-observation-travel-hdr.md),[CZ_ObservationWeightHdr](StructureDefinition-cz-observation-weight-hdr.md),[Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c035](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c035.md),[Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c03b](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.md),[Composition/701f51d5-78bf-428e-a6b5-349c2614ce07](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md),[Composition/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf](Composition-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf.md),[DocumentReference/66678621-df93-47ca-a36c-2a39a92472e7](DocumentReference-66678621-df93-47ca-a36c-2a39a92472e7.md),[DocumentReference/d9ad8a22-a12b-48db-938c-4066a3a0617a](DocumentReference-d9ad8a22-a12b-48db-938c-4066a3a0617a.md),[ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md),[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md),[Observation/5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md),[Observation/5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md),[Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md),[Observation/6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md),[Observation/7cf304de-5ae3-4621-8531-9c8f0b2d4e3a](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md),[Observation/8d2aea77-f576-4d0f-9508-537359aa44d6](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md)and[Observation/Observation-TravelHistory-Madagaskar](Observation-Observation-TravelHistory-Madagaskar.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/AllergyInfoUnknown](AllergyIntolerance-AllergyInfoUnknown.md)...Show 73 more,[AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md),[AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md),[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md),[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md),[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-core](Bundle-DischargeBundle-Novak-Petr-L1-core.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZProvisionCode](ValueSet-cz-provision-code.md),[CZ_CompositionHdr](StructureDefinition-cz-composition-hdr.md),[CZ_CompositionObligationsHdr](StructureDefinition-cz-composition-obl-hdr.md),[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[CZ_DeviceUseStatementHdr](StructureDefinition-cz-deviceUseStatement-hdr.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[CZ_FamilyMemberHistoryHdr](StructureDefinition-cz-familyMemberHistory-hdr.md),[CZ_ImmunizationHdr](StructureDefinition-cz-immunization-hdr.md),[CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md),[CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md),[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[CZ_ProcedureHdr](StructureDefinition-cz-procedure-hdr.md),[Composition/701f51d5-78bf-428e-a6b5-349c2614ce07](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md),[Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md),[Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md),[Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md),[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md),[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md),[Device/Device-Pacemaker](Device-Device-Pacemaker.md),[DeviceUseStatement/DeviceUseStatement-Pacemaker](DeviceUseStatement-DeviceUseStatement-Pacemaker.md),[EHDSIConditionPOA](ValueSet-eHDSIConditionPOA.md),[EHDSITreatmentClass](ValueSet-eHDSITreatmentClass.md),[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md),[ExposureAgentHdrVs](ValueSet-exposureAgent-eu-hdr.md),[Goal/620b1120-cece-44b1-89f5-20413054eb1d](Goal-620b1120-cece-44b1-89f5-20413054eb1d.md),[Immunization/3f85726c-ad2f-441b-89ce-10000000001e](Immunization-3f85726c-ad2f-441b-89ce-10000000001e.md),[Immunization/Immunization-CovidExample](Immunization-Immunization-CovidExample.md),[ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md),[MedicationStatement/47472c99-09bf-4007-bfaa-16c9665ae090](MedicationStatement-47472c99-09bf-4007-bfaa-16c9665ae090.md),[MedicationStatement/bf08b62b-0abd-4e88-9092-ce0228382e51](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.md),[MedicationStatement/f34114fc-138f-4bd8-8e1a-804d14ec9986](MedicationStatement-f34114fc-138f-4bd8-8e1a-804d14ec9986.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001c](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001d](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/3f85726c-ad2f-441b-89ce-100000000022](Observation-3f85726c-ad2f-441b-89ce-100000000022.md),[Observation/3f85726c-ad2f-441b-89ce-100000000023](Observation-3f85726c-ad2f-441b-89ce-100000000023.md),[Observation/3f85726c-ad2f-441b-89ce-100000000024](Observation-3f85726c-ad2f-441b-89ce-100000000024.md),[Observation/3f85726c-ad2f-441b-89ce-100000000025](Observation-3f85726c-ad2f-441b-89ce-100000000025.md),[Observation/3f85726c-ad2f-441b-89ce-100000000027](Observation-3f85726c-ad2f-441b-89ce-100000000027.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md),[Observation/ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md),[Observation/ExampleSdohSmoking](Observation-ExampleSdohSmoking.md),[Observation/Observation-Education-level](Observation-Observation-Education-level.md),[Observation/e15aeeaf-e288-404c-9704-9c8f0b2d4e3a](Observation-e15aeeaf-e288-404c-9704-9c8f0b2d4e3a.md),[PractitionerRole/2b7e9637-5018-4542-9faf-d5abdee7b849](PractitionerRole-2b7e9637-5018-4542-9faf-d5abdee7b849.md),[PractitionerRole/69d34ceb-b556-4f75-9e4c-9184fe8a10c5](PractitionerRole-69d34ceb-b556-4f75-9e4c-9184fe8a10c5.md),[PractitionerRole/Practitioner-Referrer-detail](PractitionerRole-Practitioner-Referrer-detail.md),[PractitionerRole/practitionerrole1](PractitionerRole-practitionerrole1.md),[Procedure/CZ-Procedure-HDR-Example-Acute-appendicitis](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md),[Procedure/ColonoscopyProcedure](Procedure-ColonoscopyProcedure.md),[Procedure/Procedure-Appendectomy](Procedure-Procedure-Appendectomy.md),[Procedure/Procedure-Insert-Pacemaker](Procedure-Procedure-Insert-Pacemaker.md),[Procedure/Procedure-Insert-Pacemaker2](Procedure-Procedure-Insert-Pacemaker2.md),[Procedure/ffb1a62f-9050-4e33-af4b-4cdb8203c9e5](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md)and[Specimen/Specimen-EDTA-1](Specimen-Specimen-EDTA-1.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Admit source](http://terminology.hl7.org/7.0.1/CodeSystem-admit-source.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 4 more,[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)and[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/AllergyInfoUnknown](AllergyIntolerance-AllergyInfoUnknown.md)...Show 6 more,[AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md),[AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md),[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md),[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)and[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md)...Show 5 more,[AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md),[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md),[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)and[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)
* [Condition Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-category.html): [Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md), [Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md)...Show 8 more,[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md)and[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-clinical.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 15 more,[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md),[Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md),[Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md),[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)and[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.1/CodeSystem-condition-ver-status.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 15 more,[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md),[Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md),[Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md),[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)and[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md)
* [Consent Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-consentcategorycodes.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md), [Consent/CZ-AdvanceDirectives-HDR-CORE](Consent-CZ-AdvanceDirectives-HDR-CORE.md) and [Consent/CZ-AdvanceDirectives-HDR-DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md)
* [Consent Scope Codes](http://terminology.hl7.org/7.0.1/CodeSystem-consentscope.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md), [Consent/CZ-AdvanceDirectives-HDR-CORE](Consent-CZ-AdvanceDirectives-HDR-CORE.md) and [Consent/CZ-AdvanceDirectives-HDR-DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md)
* [Diagnosis Role](http://terminology.hl7.org/7.0.1/CodeSystem-diagnosis-role.html): [Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [Discharge disposition](http://terminology.hl7.org/7.0.1/CodeSystem-discharge-disposition.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 4 more,[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)and[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [Immunization Recommendation Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-immunization-recommendation-status.html): [ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md)
* [Location type](http://terminology.hl7.org/7.0.1/CodeSystem-location-physical-type.html): [Nemocnice Chrudim - Oddělení CHIR-JIP](Location-cz-Location-Chrudim-ChirJIP.md), [Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)...Show 5 more,[Nemocnice Praha](Location-example-cz-location.md),[Nemocnice Praha - Klinika Chirurgie](Location-Location-5.md),[Nemocnice Praha - Oddělení A](Location-sample-cz-location-2.md),[Nemocnice Praha - Oddělení B](Location-sample-cz-location-3.md)and[Nemocnice Praha - Oddělení C](Location-sample-cz-location-4.md)
* [Medication request administration location codes](http://terminology.hl7.org/7.0.1/CodeSystem-medicationrequest-admin-location.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md), [MedicationStatement/47472c99-09bf-4007-bfaa-16c9665ae090](MedicationStatement-47472c99-09bf-4007-bfaa-16c9665ae090.md), [MedicationStatement/bf08b62b-0abd-4e88-9092-ce0228382e51](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.md) and [MedicationStatement/f34114fc-138f-4bd8-8e1a-804d14ec9986](MedicationStatement-f34114fc-138f-4bd8-8e1a-804d14ec9986.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 22 more,[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001c](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001d](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/3f85726c-ad2f-441b-89ce-100000000022](Observation-3f85726c-ad2f-441b-89ce-100000000022.md),[Observation/3f85726c-ad2f-441b-89ce-100000000023](Observation-3f85726c-ad2f-441b-89ce-100000000023.md),[Observation/3f85726c-ad2f-441b-89ce-100000000024](Observation-3f85726c-ad2f-441b-89ce-100000000024.md),[Observation/3f85726c-ad2f-441b-89ce-100000000025](Observation-3f85726c-ad2f-441b-89ce-100000000025.md),[Observation/3f85726c-ad2f-441b-89ce-100000000027](Observation-3f85726c-ad2f-441b-89ce-100000000027.md),[Observation/4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md),[Observation/5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md),[Observation/5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md),[Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md),[Observation/6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md),[Observation/7cf304de-5ae3-4621-8531-9c8f0b2d4e3a](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md),[Observation/8d2aea77-f576-4d0f-9508-537359aa44d6](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md),[Observation/ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md),[Observation/ExampleSdohSmoking](Observation-ExampleSdohSmoking.md),[Observation/Observation-Education-level](Observation-Observation-Education-level.md)and[Observation/e15aeeaf-e288-404c-9704-9c8f0b2d4e3a](Observation-e15aeeaf-e288-404c-9704-9c8f0b2d4e3a.md)
* [contactRole2](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0131.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 4 more,[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Patient/3f85726c-ad2f-441b-89ce-100000000000](Patient-3f85726c-ad2f-441b-89ce-100000000000.md)and[Patient/Mracena2](Patient-Mracena2.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [CZ_PatientObligationsHdr](StructureDefinition-cz-patient-obl-hdr.md), [CZ_RelatedPersonHdr](StructureDefinition-cz-relatedPerson-hdr.md), [CZ_RelatedPersonObligationsHdr](StructureDefinition-cz-relatedPerson-obl-hdr.md) and [Patient/Mracena2](Patient-Mracena2.md)
* [providerRole](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0443.html): [CZ_ImmunizationHdr](StructureDefinition-cz-immunization-hdr.md) and [CZ_ImmunizationObligationsHdr](StructureDefinition-cz-immunization-obl-hdr.md)
* [ActClass](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActClass.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md), [CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md) and [Observation/Observation-InfectiousContact](Observation-Observation-InfectiousContact.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 8 more,[Bundle/DischargeBundle-Novak-Petr-L1-core](Bundle-DischargeBundle-Novak-Petr-L1-core.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md),[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md),[Encounter/HospitalEncounter](Encounter-HospitalEncounter.md)and[Encounter/f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md)
* [ActPriority](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActPriority.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 5 more,[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)and[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [Education Level](http://terminology.hl7.org/7.0.1/CodeSystem-v3-EducationLevel.html): [Observation/Observation-Education-level](Observation-Observation-Education-level.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 7 more,[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/hb-result](Observation-hb-result.md),[Observation/hct-result](Observation-hct-result.md),[Observation/plt-result](Observation-plt-result.md),[Observation/rbc-result](Observation-rbc-result.md)and[Observation/wbc-result](Observation-wbc-result.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 10 more,[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[CZ_EncounterObligationsHdr](StructureDefinition-cz-encounter-obl-hdr.md),[CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md),[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md),[Observation/Observation-InfectiousContact](Observation-Observation-InfectiousContact.md),[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab.md)and[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 6 more,[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_RelatedPersonHdr](StructureDefinition-cz-relatedPerson-hdr.md),[Patient/3f85726c-ad2f-441b-89ce-100000000000](Patient-3f85726c-ad2f-441b-89ce-100000000000.md),[Patient/Mracena2](Patient-Mracena2.md)and[RelatedPersonRelationshipTypesHDR](ValueSet-relatedPersonRelationshipTypes-eu-hdr.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cz.hdr",
  "url" : "https://hl7.cz/fhir/hdr/ImplementationGuide/hl7.fhir.cz.hdr",
  "version" : "0.1.0",
  "name" : "HL7CzHospitalDischargeIg",
  "title" : "HL7 Czech Hospital Discharge Report Implementation Guide",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This guide contains implementation specification for the HL7 Czech Hospital Discharge Report",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.cz.hdr",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_fhir_eu_extensions",
      "uri" : "http://hl7.eu/fhir/extensions/ImplementationGuide/hl7.fhir.eu.extensions",
      "packageId" : "hl7.fhir.eu.extensions",
      "version" : "0.1.1-ballot"
    },
    {
      "id" : "hl7_fhir_eu_laboratory",
      "uri" : "http://hl7.eu/fhir/laboratory/ImplementationGuide/hl7.fhir.eu.laboratory",
      "packageId" : "hl7.fhir.eu.laboratory",
      "version" : "0.1.1"
    },
    {
      "id" : "hl7_fhir_eu_base",
      "uri" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
      "packageId" : "hl7.fhir.eu.base",
      "version" : "0.1.0-ballot"
    },
    {
      "id" : "hl7_fhir_eu_hdr",
      "uri" : "http://hl7.eu/fhir/hdr/ImplementationGuide/hl7.fhir.eu.hdr",
      "packageId" : "hl7.fhir.eu.hdr",
      "version" : "0.1.0-ballot"
    },
    {
      "id" : "ihe_pharm_mpd",
      "uri" : "https://profiles.ihe.net/PHARM/MPD/ImplementationGuide/ihe.pharm.mpd",
      "packageId" : "ihe.pharm.mpd",
      "version" : "1.0.0-comment-2"
    },
    {
      "id" : "hl7_fhir_cz_core",
      "uri" : "https://hl7.cz/fhir/core/ImplementationGuide/hl7.fhir.cz.core",
      "packageId" : "hl7.fhir.cz.core",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_cz_lab",
      "uri" : "https://hl7.cz/fhir/lab/ImplementationGuide/hl7.fhir.cz.lab",
      "packageId" : "hl7.fhir.cz.lab",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_cz_img",
      "uri" : "https://hl7.cz/fhir/img/ImplementationGuide/hl7.fhir.cz.img",
      "packageId" : "hl7.fhir.cz.img",
      "version" : "current"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/hdr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/hdr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "obligations",
        "name" : "Obligations",
        "description" : "Obligations used to describe the HDR functional requirements for the specified data elements. Informative for this version of the guide."
      },
      {
        "id" : "czech-logical-model",
        "name" : "Czech logical model",
        "description" : "Logical model in czech language. Informative for this version of the guide."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalDischargeReportCz"
        },
        "name" : "A - Hospital Discharge Report (eHN)",
        "description" : "Hospital Discharge Report",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogHospitalDischargeReportCz"
        },
        "name" : "A - Propouštěcí zpráva",
        "description" : "Nemocniční propouštěcí zpráva",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Header"
        },
        "name" : "A.1 - Hospital Discharge Report header data element",
        "description" : "Hospital Discharge Report - Hospital Discharge Report header data element - A.1 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogHeaderHdrCz"
        },
        "name" : "A.1 – Hlavička dokumentu",
        "description" : "Nemocniční propouštěcí zpráva - Struktura hlavičky propouštěcí zprávy podle tabulky části.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubjectCz"
        },
        "name" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "description" : "Hospital Discharge Report - Hospital Discharge Report subject data element - A.1.1 and A.1.2 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogSubjectCz"
        },
        "name" : "A.1.1 - Identifikace a A.1.2 - informace o pacientovi",
        "description" : "Nemocniční propouštěcí zpráva - Informace o pacientovi.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/digitalSignatureCz"
        },
        "name" : "A.1.9 - Digital signature",
        "description" : "Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogdigitalSignatureCz"
        },
        "name" : "A.1.9 - Digitální podpis",
        "description" : "Nemocniční propouštěcí zpráva - Elektronický podpis dle zákona 327/2011 §54a",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdvanceDirectivesCz"
        },
        "name" : "A.2.1 - Advance Directives (eHN)",
        "description" : "Hospital Discharge Report - Advance Directives - A.2.1 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAdvanceDirectivesCz"
        },
        "name" : "A.2.1 - Dříve vyslovená přání (cz)",
        "description" : "Nemocniční propouštěcí zpráva - Dříve vyslovená přání",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AlertsCz"
        },
        "name" : "A.2.2 - Alerts (eHN)",
        "description" : "Hospital Discharge Report - Alerts - A.2.2 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAlertsCz"
        },
        "name" : "A.2.2 - Urgentní informace (cz)",
        "description" : "Nemocniční propouštěcí zpráva - Urgentní informace",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/InPatientEncounterCz"
        },
        "name" : "A.2.3 - Encounter (eHN)",
        "description" : "Hospital Discharge Report - Encounter - A.2.3 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogInPatientEncounterCz"
        },
        "name" : "A.2.3 - Kontakt se zdravotními službami",
        "description" : "Nemocniční propouštěcí zpráva - Záznam o hospitalizačním kontaktu v rámci propouštěcí zprávy.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdmissionEvaluationEhnEn"
        },
        "name" : "A.2.4 - Admission evaluation (eHN)",
        "description" : "Hospital Discharge Report - Admission evaluation - A.2.4 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAdmissionEvaluationCz"
        },
        "name" : "A.2.4 - Stav při přijetí (cz)",
        "description" : "Nemocniční propouštěcí zpráva - Stav při přijetí - A.2.4 CZ poznámka: Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PatientHistoryCz"
        },
        "name" : "A.2.5 - Patient history (eHN)",
        "description" : "Hospital Discharge Report - Patient history - A.2.5 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPatientHistoryCz"
        },
        "name" : "A.2.6 - Anamnéza",
        "description" : "Nemocniční propouštěcí zpráva - Anamnéza",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalStayCz"
        },
        "name" : "A.2.6 - Hospital stay (eHN)",
        "description" : "Hospital Discharge Report - Hospital stay - A.2.6 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DischargeDetailsCz"
        },
        "name" : "A.2.7 - Discharge details (eHN)",
        "description" : "Hospital Discharge Report - Discharge details - A.2.7 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogDischargeDetailsCz"
        },
        "name" : "A.2.7 - Průběh hospitalizace",
        "description" : "Nemocniční propouštěcí zpráva - Průběh hospitalizace",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogHospitalStayCz"
        },
        "name" : "A.2.7 Průběh hospitalizace",
        "description" : "Nemocniční propouštěcí zpráva - Popis průběhu hospitalizace zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ObjectiveFindingsCz"
        },
        "name" : "A.2.7.1 - Objective findings",
        "description" : "Hospital Discharge Report - Objective Findings- A.2.7.1 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlanOfCareCz"
        },
        "name" : "A.2.8.1 - Care plan",
        "description" : "Hospital Discharge Report - Care plan after discharge - A.2.8.1 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogCzObjectiveFindingsCz"
        },
        "name" : "A.2.8.1 Objektivní nález",
        "description" : "Nemocniční propouštěcí zpráva - Objektivní nález pacienta při propuštění.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FunctionalStatusCz"
        },
        "name" : "A.2.8.2 - Functional status",
        "description" : "Hospital Discharge Report - Functional status  - A.2.8.2 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogFunctionalStatusCz"
        },
        "name" : "A.2.8.2 - Funkční stav při propuštění",
        "description" : "Nemocniční propouštěcí zpráva - Hodnocení funkčního stavu pacienta při propuštění.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationSummaryCz"
        },
        "name" : "A.2.8.2 - Medication summary",
        "description" : "Hospital Discharge Report - Medication Summary after discharge - A.2.8.2 eHN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPlanOfCareCz"
        },
        "name" : "A.2.9.1 Plán péče",
        "description" : "Nemocniční propouštěcí zpráva - Plán péče po propuštění.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogMedicationSummaryCz"
        },
        "name" : "A.2.9.2 Souhrn medikace",
        "description" : "Nemocniční propouštěcí zpráva - Souhrnná informace o medikaci doporučené na období po propuštění, včetně medikace změněné, nově zahájené nebo ukončené.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PresentedFormCz"
        },
        "name" : "A.3 - Presented form",
        "description" : "Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPresentedFormCz"
        },
        "name" : "A.3 - Vizuální podoba dokumentu",
        "description" : "Nemocniční propouštěcí zpráva - čitelná lidským okem, je požadován PDF formát. Obsahuje informace o průběhu hospitalizace v rozsahu vydané zprávy.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AttachmentsCz"
        },
        "name" : "A.4 - Additional attachments",
        "description" : "Discharge Report - additional attachments - A.4",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAttachmentsCz"
        },
        "name" : "A.4 - Přílohy (cz)",
        "description" : "Nemocniční propouštěcí zpráva - Přílohy",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-address-obl-hdr"
        },
        "name" : "Address Obligations (HDR CZ)",
        "description" : "Obligations for Address in Czech Republic - HDR",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/CZ-AdvanceDirectives-HDR-CORE"
        },
        "name" : "AdvanceDirectives  CORE",
        "description" : "Czech hdr - example od advance directive",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/CZ-AdvanceDirectives-HDR-DNR"
        },
        "name" : "AdvanceDirectives  DNR",
        "description" : "Czech hdr - example od advance directive",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/AllergyInfoUnknown"
        },
        "name" : "Allergy Information Unknown",
        "description" : "No information is available regarding the patient’s allergy status.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-allergyIntolerance-hdr"
        },
        "name" : "Allergy Intolerance (HDR CZ)",
        "description" : "This profile constrains the AllergyIntolerance resource for the purpose of this project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-allergyintolerance-obl-hdr"
        },
        "name" : "Allergy Intolerance Obligations (HDR CZ)",
        "description" : "This profile defines the obligations for the CZ_AllergyIntoleranceHdr profile used in the HDR CZ project.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/MilkAllergy"
        },
        "name" : "AllergyIntolerance - cow's milk protein",
        "description" : "Patient experiences rash and itching after ingestion of cow's milk protein due to intolerance.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/NoKnownAllergy"
        },
        "name" : "AllergyIntolerance - No Known Allergies",
        "description" : "Patient has no known allergies.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/PenicillinAllergy"
        },
        "name" : "AllergyIntolerance - Penicillin",
        "description" : "Patient experiences skin rash and lip swelling in response to penicillin.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/StrawberryAllergy"
        },
        "name" : "AllergyIntolerance - Strawberry",
        "description" : "Patient experiences itching and tongue swelling in response to strawberries.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b"
        },
        "name" : "AllergyIntolerance - Strawberry",
        "description" : "Patient experiences itching and tongue swelling in response to strawberries.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Organization-Referrer"
        },
        "name" : "Ambulance interního lékařství, MUDr. Jiří Zdvořilý",
        "description" : "Example of ambulatory physician",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-attachment-hdr"
        },
        "name" : "Attachment: HDR (CZ)",
        "description" : "Czech profile for attachment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-attachment-obl-hdr"
        },
        "name" : "Attachments: Obligations",
        "description" : "This profile defines obligations for an attachment in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bundle-hdr"
        },
        "name" : "Bundle (HDR CZ)",
        "description" : "Clinical document used to represent a Hospital Discharge Report for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Flag"
          }
        ],
        "reference" : {
          "reference" : "Flag/Flag1"
        },
        "name" : "Cardiac Arrest Flag",
        "description" : "A flag indicating that the patient has a history of cardiac arrest.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-carePlan-hdr"
        },
        "name" : "Care Plan (HDR CZ)",
        "description" : "This profile constrains the CarePlan resource for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CarePlan"
          }
        ],
        "reference" : {
          "reference" : "CarePlan/9c913d06-84fe-4d35-b35b-8b0c7965f535"
        },
        "name" : "CarePlan-Novak-Petr",
        "description" : "Czech HDR - example of a care plan",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-composition-hdr"
        },
        "name" : "Composition (HDR CZ)",
        "description" : "This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-composition-obl-hdr"
        },
        "name" : "Composition: Obligations",
        "description" : "This profile defines obligations for a composition in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-condition-hdr"
        },
        "name" : "Condition (HDR CZ)",
        "description" : "This profile represents the constraint applied to the Condition in the scope of this guide. It supports the Diagnostic summary part of the eHN data model adding two additional categories: First category distinguishes conditions present at admission and acquired during hospital stay, while second category is used to indicate impact of the condition to the treatment during hospital stay (treated, untreated).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-consent-hdr"
        },
        "name" : "Consent (Advance Directives) (HDR CZ)",
        "description" : "This profile constrains the Consent resource for the purpose of representing Advance Directives in this project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-consent-obl-hdr"
        },
        "name" : "Consent Obligations (HDR CZ)",
        "description" : "This profile defines the obligations for the CZ_ConsentHdr profile used in the HDR CZ project.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-coverage-obl-hdr"
        },
        "name" : "Coverage: Obligations",
        "description" : "This profile defines obligations for a coverage in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/10f5c49e-086d-4016-8dd1-10000000001b"
        },
        "name" : "CRP - Novák Petr",
        "description" : "Czech HDR - example of CRP observation for Novák Petr",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/advanceDirectives2FHIR-cz-hdr"
        },
        "name" : "CZ Advance Directives Model to this guide Map",
        "description" : "eHN HDR Advance Directives Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/alerts2FHIR-cz-hdr"
        },
        "name" : "CZ Alerts Model to this guide Map",
        "description" : "eHN HDR Alerts Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/AttachmentHDR2FHIR-cz"
        },
        "name" : "CZ Attachment Model to this guide Map",
        "description" : "CZ HDR Attachment Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-consent-category"
        },
        "name" : "CZ Consent Category",
        "description" : "ValueSet for Consent Categories in the Czech HDR project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/hdr2FHIR-cz-hdr"
        },
        "name" : "CZ HDR Model to this guide Map",
        "description" : "CZ Hospital Discharge Report Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/hdrHeader2FHIR-cz-hdr"
        },
        "name" : "CZ Header Model to this guide Map",
        "description" : "CZ HDR Header Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/patientHistory2FHIR-cz-hdr"
        },
        "name" : "CZ Patient History to this guide Map",
        "description" : "CZ HDR Patient History Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-provision-code"
        },
        "name" : "CZ Provision Code",
        "description" : "ValueSet for provision codes in the Czech HDR project, using ICD-10 and Orphacode.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CarePlan"
          }
        ],
        "reference" : {
          "reference" : "CarePlan/CZ-CarePlan-HDR-Example"
        },
        "name" : "CZ-CarePlan-HDR Example",
        "description" : "Czech HDR - example of a care plan",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/AngiodysplasiaCondition"
        },
        "name" : "CZ-Condition-HDR Angiodysplasia",
        "description" : "Example of a condition Angiodysplasia of colon",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/AtrialFibrillationCondition"
        },
        "name" : "CZ-Condition-HDR Atrial Fibrillation",
        "description" : "Example of a condition Persistent atrial fibrillation",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/CZ-Condition-HDR-Example"
        },
        "name" : "CZ-Condition-HDR Example",
        "description" : "Czech HDR - example of a condition (Heart Failure)",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/CZ-Condition-HDR-Example-2"
        },
        "name" : "CZ-Condition-HDR Example 2",
        "description" : "Czech HDR - example of a condition (Cardiac arrhythmia - Brugada Syndrome)",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f"
        },
        "name" : "CZ-Condition-HDR Example 3",
        "description" : "Czech HDR - example of a condition (Postoperative Hypothyroidism)",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/CZ-Condition-HDR-Example-3"
        },
        "name" : "CZ-Condition-HDR Example 3",
        "description" : "Czech HDR - example of a condition (Postoperative Hypothyroidism)",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/35717696-8a99-4f99-a938-ec0ec88a65a2"
        },
        "name" : "CZ-Condition-HDR Example K409",
        "description" : "Example of a condition K409 with details on admission",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/HypercholesterolemiaCondition"
        },
        "name" : "CZ-Condition-HDR Hypercholesterolemia",
        "description" : "Example of a condition Pure hypercholesterolaemia",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/HypothyroidismCondition"
        },
        "name" : "CZ-Condition-HDR Hypothyroidism",
        "description" : "Example of a condition Hypothyroidism",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/IronDeficiencyAnemiaCondition"
        },
        "name" : "CZ-Condition-HDR Iron Deficiency Anemia",
        "description" : "Example of a condition Iron deficiency anaemia secondary to blood loss (chronic)",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/OsteoporosisCondition"
        },
        "name" : "CZ-Condition-HDR Osteoporosis",
        "description" : "Example of a condition Postmenopausal osteoporosis",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/PresbycusisCondition"
        },
        "name" : "CZ-Condition-HDR Presbycusis",
        "description" : "Example of a condition Presbycusis",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/TIACondition"
        },
        "name" : "CZ-Condition-HDR TIA",
        "description" : "Example of a condition Transient cerebral ischaemic attack, unspecified",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/VaricoseVeinsCondition"
        },
        "name" : "CZ-Condition-HDR Varicose Veins",
        "description" : "Example of a condition Varicose veins of lower extremities without ulcer or inflammation",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb"
        },
        "name" : "CZ-Encounter-HDR  L1 Example of encounter for Novak Petr",
        "description" : "Czech HDR – a minimalist example of a encounter for Petr Novák for the document L1 HDR",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/CZ-Encounter-HDR-Example"
        },
        "name" : "CZ-Encounter-HDR Example",
        "description" : "Czech HDR - example of an inpatient encounter",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/10f5c49e-086d-4016-8dd1-b555306bf620"
        },
        "name" : "CZ-Encounter-HDR Example of encounter with emergency priority",
        "description" : "Czech HDR - example of encounter with emergency priority",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/HospitalEncounter"
        },
        "name" : "CZ-Encounter-HDR Example of finished hospital encounter",
        "description" : "Czech HDR - example of finished hospital encounter",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/AtorvastatinMedication"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Atorvastatin",
        "description" : "Czech HDR - example of Atorvastatin",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/BisoprololMedication"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Bisoprolol",
        "description" : "Czech HDR - example of Bisoprolol",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/CalciumD3Medication"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Calcium D3",
        "description" : "Czech HDR - example of Calcium D3",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/47472c99-09bf-4007-bfaa-16c9665ae090"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Euthyrox",
        "description" : "Czech HDR - example of Euthyrox",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/bf08b62b-0abd-4e88-9092-ce0228382e51"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Ibalgin",
        "description" : "Czech HDR - example of Ibalgin 400",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/IronSupplementMedication"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Iron Supplement",
        "description" : "Czech HDR - example of Iron Supplement",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/LevothyroxineMedication"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Levothyroxine",
        "description" : "Czech HDR - example of Levothyroxine sodium",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/f34114fc-138f-4bd8-8e1a-804d14ec9986"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Paracetamol",
        "description" : "Czech HDR - example of Paracetamol",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/RivaroxabanMedication"
        },
        "name" : "CZ-MedicationStatement-HDR Example of Rivaroxaban",
        "description" : "Czech HDR - example of Rivaroxaban",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/CZ-Procedure-HDR-Example-Acute-appendicitis"
        },
        "name" : "CZ-Procedure-HDR Example - Acute appendicitis",
        "description" : "Czech HDR - example of a Procedure - Acute appendicitis.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/Procedure-Appendectomy"
        },
        "name" : "CZ-Procedure-HDR Example - Appendectomy",
        "description" : "Czech HDR - example of a Procedure - Appendectomy",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/ColonoscopyProcedure"
        },
        "name" : "CZ-Procedure-HDR Example - Colonoscopy",
        "description" : "Czech HDR - example of a Procedure - Colonoscopy",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/ffb1a62f-9050-4e33-af4b-4cdb8203c9e5"
        },
        "name" : "CZ-Procedure-HDR Example - Inguinal hernia",
        "description" : "Czech HDR - example of a Procedure - Repair of inguinal hernia",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/Procedure-No-Procedure"
        },
        "name" : "CZ-Procedure-HDR Example - No known procedures",
        "description" : "Czech HDR - example of a Procedure - No known procedures.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/Procedure-Insert-Pacemaker2"
        },
        "name" : "CZ-Procedure-HDR Example - Pacemaker",
        "description" : "Czech HDR - example of a Procedure - Pacemaker",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/Procedure-Insert-Pacemaker"
        },
        "name" : "CZ-Procedure-HDR Example - Pacemaker",
        "description" : "Czech HDR - example of a Procedure - Pacemaker",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/CZObservationSdohHdrExample"
        },
        "name" : "CZObservationSdohHdrExample",
        "description" : "Example instance for SDOH observation (assessment-based) using CZ_ObservationSdohHdr profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/Device-Pacemaker"
        },
        "name" : "Device-Pacemaker",
        "description" : "Heart pacemaker Medtronic W1DR01",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-deviceUseStatement-hdr"
        },
        "name" : "DeviceUseStatement (HDR)",
        "description" : "This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/d9ad8a22-a12b-48db-938c-4066a3a0617a"
        },
        "name" : "Discharge Summary Document - Base64",
        "description" : "DocumentReference for discharge summary, base64 encoded HTML",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/66678621-df93-47ca-a36c-2a39a92472e7"
        },
        "name" : "Discharge Summary Document - PDF",
        "description" : "DocumentReference with Base64 PDF content directly inserted",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/DischargeBundle-Novak-Petr"
        },
        "name" : "DischargeBundle-Novak-Petr",
        "description" : "Example Bundle for Hospital Discharge Report for patient Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/DischargeBundle-Novak-Petr-L1"
        },
        "name" : "DischargeBundle-Novak-Petr-L1",
        "description" : "Example Bundle for Hospital Discharge Report for patient Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/DischargeBundle-Novak-Petr-L1-core"
        },
        "name" : "DischargeBundle-Novak-Petr-L1-core",
        "description" : "Example of a minimalist L1 package for the discharge report of patient Novák Petr from the hospital",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/DischargeBundle-Novak-Petr-L1-plus"
        },
        "name" : "DischargeBundle-Novak-Petr-L1-plus",
        "description" : "Example Bundle for Hospital Discharge Report for patient Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/DischargeBundle-Novak-Petr-Subsections"
        },
        "name" : "DischargeBundle-Novak-Petr-Subsections",
        "description" : "Example Bundle for Hospital Discharge Report for patient Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MedicationDispense-Euthyrox"
        },
        "name" : "Dispense – Euthyrox",
        "description" : "Výdej léčivého přípravku Euthyrox pacientovi Novákovi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/Medication-Euthyrox"
        },
        "name" : "Dispense – Euthyrox",
        "description" : "Euthyrox v tabletách",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MedicationDispense-Ibalgin400"
        },
        "name" : "Dispense – Ibalgin 400",
        "description" : "Výdej léčivého přípravku Ibalgin 400 mg pacientovi Novákovi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MedicationDispense-Paracetamol"
        },
        "name" : "Dispense – Paracetamol",
        "description" : "Výdej léčivého přípravku Paracetamol pacientovi Novákovi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-dosage-hospitalstay-obl-hdr"
        },
        "name" : "Dosage: Obligations (HDR CZ) - hospital stay",
        "description" : "Profile for Dosage with obligations (HDR CZ) - hospital stay.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-dosage-medicationsummary-obl-hdr"
        },
        "name" : "Dosage: Obligations (HDR CZ) - medication summary",
        "description" : "Profile for Dosage with obligations (HDR CZ) - medication summary.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Observation-Education-level"
        },
        "name" : "Dosažený stupeň vzdělání",
        "description" : "Pacient má vysokoškolské vzdělání v oboru informatiky.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/eHDSIConditionPOA"
        },
        "name" : "eHDSI Condition Present On Admission",
        "description" : "The Value Set is used to assert if a condition is Present on Admission",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/eHDSITreatmentClass"
        },
        "name" : "eHDSI Treatment Class",
        "description" : "The Value set is used to encode category of treatment of the condition during encounter",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/encounter2FHIR-cz-hdr"
        },
        "name" : "eHN Encounter Model to this guide Map",
        "description" : "eHN HDR Encounter Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/functionalStatus2FHIR-hdr-cz"
        },
        "name" : "eHN Functional Status Model to this guide Map",
        "description" : "eHN HDR Functional Status Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/hospitalStay2FHIR-cz-hdr"
        },
        "name" : "eHN Hospital Stay Model to this guide Map",
        "description" : "eHN HDR Hospital Stay  Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/medicationSummary2FHIR-cz-hdr"
        },
        "name" : "eHN Medication Summary Model to this guide Map",
        "description" : "eHN HDR Medication Summary Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/objectiveFindings2FHIR-hdr-cz"
        },
        "name" : "eHN Objective Findings Model to this guide Map",
        "description" : "eHN HDR Objective Findings Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/planOfCare2FHIR-cz-hdr"
        },
        "name" : "eHN Plan of Care Model to this guide Map",
        "description" : "eHN HDR Plan of Care Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/subject2FHIR-cz-hdr"
        },
        "name" : "eHN Subject Model to this guide Map",
        "description" : "eHN HDR Subject Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-encounter-hdr"
        },
        "name" : "Encounter (HDR CZ)",
        "description" : "This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-encounter-obl-hdr"
        },
        "name" : "Encounter: Obligations",
        "description" : "This profile defines obligations for an Encounter in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/rbc-result"
        },
        "name" : "Erytrocyty",
        "description" : "Příklad pro HDR - Počet erytrocytů v krvi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-cz-location"
        },
        "name" : "Example Czech Location",
        "description" : "Example instance of a location conforming to the CZ_LocationCore profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a"
        },
        "name" : "ExampleAbdominalCircumference",
        "description" : "Example instance for abdominal circumference observation using the CZ_ObservationAbdominalCircumferenceHdr profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-abdominalCircumference-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/8d2aea77-f576-4d0f-9508-537359aa44d6"
        },
        "name" : "ExampleBloodPressure",
        "description" : "Example instance for blood pressure observation (systolic and diastolic).",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/7cf304de-5ae3-4621-8531-9c8f0b2d4e3a"
        },
        "name" : "ExampleBMI",
        "description" : "Example instance for BMI observation using the CZ_ObservationBMIHdr profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-BMI-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a"
        },
        "name" : "ExampleChestCircumference",
        "description" : "Example instance for chest circumference observation using the CZ_ObservationChestCircumferenceHdr profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-chestCircumference-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d"
        },
        "name" : "ExampleHeadCircumference",
        "description" : "Example instance for head circumference observation using the CZ_ObservationHeadCircumferenceHdr profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-headCircumference-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b"
        },
        "name" : "ExampleHeight",
        "description" : "Example instance for height observation using the CZ_ObservationHeightHdr profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-height-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleSdohAlcohol"
        },
        "name" : "ExampleSdohAlcohol",
        "description" : "Example of Social History Observation - Alcohol Use",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-10000000001d"
        },
        "name" : "ExampleSdohAlcoholSporadic",
        "description" : "Example of Social History Observation - Alcohol Use",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleSdohSmoking"
        },
        "name" : "ExampleSdohSmoking",
        "description" : "Example of Social History Observation - Smoking",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-10000000001c"
        },
        "name" : "ExampleSdohSmokingEnded",
        "description" : "Example of Social History Observation - Smoking history",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c"
        },
        "name" : "ExampleWeight",
        "description" : "Example instance for weight observation using the CZ_ObservationWeightHdr profile.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-weight-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/exposureAgent-eu-hdr"
        },
        "name" : "Exposure of transmissible agents",
        "description" : "HDR exposure agent value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 40733004 \"Infectious disease (disorder)\" and ICD-10 all descendants of chapter I: \"Certain infectious and parasitic diseases\"",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-familyMemberHistory-hdr"
        },
        "name" : "FamilyMemberHistory (HDR CZ)",
        "description" : "This profile represents the constraints applied to the FamilyMemberHistory resource by this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-flag-hdr"
        },
        "name" : "Flag (HDR CZ)",
        "description" : "This profile constrains the Flag resource to represent alerts or warnings in FHIR for the purpose of this project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-flag-obl-hdr"
        },
        "name" : "Flag Obligations (HDR CZ)",
        "description" : "This profile defines the obligations for the CZ_FlagHdr profile used in the HDR CZ project.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Goal"
          }
        ],
        "reference" : {
          "reference" : "Goal/620b1120-cece-44b1-89f5-20413054eb1d"
        },
        "name" : "Goal for Hernia Treatment",
        "description" : "Czech HDR - example of a goal for hernia treatment",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/hct-result"
        },
        "name" : "Hematokrit",
        "description" : "Příklad pro HDR - Hematokrit v krvi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Lab-HematologieBrno"
        },
        "name" : "Hematologická laboratoř Brno",
        "description" : "Referenční laboratoř pro klinickou hematologii",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/hb-result"
        },
        "name" : "Hemoglobin",
        "description" : "Příklad pro HDR - Hladina hemoglobinu v krvi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-immunization-hdr"
        },
        "name" : "Immunization (HDR CZ)",
        "description" : "This profile constrains the Immunization resource for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/3f85726c-ad2f-441b-89ce-10000000001e"
        },
        "name" : "Immunization example of Covid",
        "description" : "Immunization of Covid",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-immunization-obl-hdr"
        },
        "name" : "Immunization Obligations: HDR CZ",
        "description" : "Profile for Immunization Obligations in the Czech Republic Health Data Repository (HDR CZ).",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImmunizationRecommendation"
          }
        ],
        "reference" : {
          "reference" : "ImmunizationRecommendation/ImmunizationRecommendation"
        },
        "name" : "Immunization recommendation example",
        "description" : "Immunization recommendation of vaccination",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-immunizationrecommendation-obl-hdr"
        },
        "name" : "Immunization Recommendation Obligations (HDR CZ)",
        "description" : "This profile defines the obligations for the ImmunizationRecommendation resource used in the HDR CZ project.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-immunizationRecommendation-hdr"
        },
        "name" : "ImmunizationRecommendation (CZ HDR)",
        "description" : "This profile defines how to represent Immunization Recommandations for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Observation-InfectiousContact"
        },
        "name" : "Infekční kontakt",
        "description" : "Pacient byl v kontaktu s osobou nakaženou COVID-19",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-infectious-contact-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-100000000024"
        },
        "name" : "Koníčky",
        "description" : "Pacient aktivně sportuje (jezdí na kole a běhá) a má zájem o fotografování.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/wbc-result"
        },
        "name" : "Leukocyty",
        "description" : "Příklad pro HDR - Počet leukocytů v krvi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicalDevice-obl-hdr"
        },
        "name" : "Medical Device: Obligations",
        "description" : "This profile defines obligations for a medical device result in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationadministration-obl-hdr"
        },
        "name" : "Medication Administration Obligations (HDR CZ)",
        "description" : "Profile for Medication Administration Obligations in the Czech Republic Health Data Repository (HDR CZ).",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medication-hospitalstay-obl-hdr"
        },
        "name" : "Medication Obligations: (HDR CZ) - hospital stay",
        "description" : "Profile for Medication Obligations in the Czech Republic Health Data Repository (HDR CZ). - hospital stay.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medication-medicationsummary-obl-hdr"
        },
        "name" : "Medication Obligations: (HDR CZ) - medication summary",
        "description" : "Profile for Medication Obligations in the Czech Republic Health Data Repository (HDR CZ). - medication summary.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/med-CovidVaccineComirnaty"
        },
        "name" : "Medication – Covid vaccine",
        "description" : "Lek Covid vakcína",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/med-Ibalgin400"
        },
        "name" : "Medication – Ibalgin 400",
        "description" : "Lek Ibalgin 400 v tabletách",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/med-paracetamol"
        },
        "name" : "Medication – Paracetamol",
        "description" : "Lek Paracetamol v tabletách",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationDispense-hdr"
        },
        "name" : "MedicationDispense (HDR)",
        "description" : "This profile constrains the MedicationDispense resource for the purpose of this guide, adapted from the MPD work.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationdispens-hospitalstay-obl-hdr"
        },
        "name" : "MedicationDispense: Obligations (HDR CZ) - hospital stay",
        "description" : "Profile for MedicationDispense with obligations (HDR CZ). - hospital stay.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationdispens-medicationsummary-obl-hdr"
        },
        "name" : "MedicationDispense: Obligations (HDR CZ) - medication summary",
        "description" : "Profile for MedicationDispense with obligations (HDR CZ). - medication summary.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationRequest-hdr"
        },
        "name" : "MedicationRequest (HDR CZ)",
        "description" : "This profile constrains the MedicationRequest resource for the purpose of this guide, adapted from the MPD work.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationrequest-hospitalstay-obl-hdr"
        },
        "name" : "MedicationRequest: Obligations (HDR CZ) - hospital stay",
        "description" : "Profile for MedicationRequest with obligations (HDR CZ) - hospital stay.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationrequest-medicationsummary-obl-hdr"
        },
        "name" : "MedicationRequest: Obligations (HDR CZ) - medication summary",
        "description" : "Profile for MedicationRequest with obligations (HDR CZ) - medication summary.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-medicationstatement-obl-hdr"
        },
        "name" : "MedicationStatement: Obligations (HDR CZ)",
        "description" : "Profile for MedicationStatement with obligations (HDR CZ).",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Mracena2"
        },
        "name" : "Mracena2",
        "description" : "Patient, contact information including registering practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Observation-TravelHistory-Madagaskar"
        },
        "name" : "Observation - Travel History",
        "description" : "Travel history observation",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-travel-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-weight-hdr"
        },
        "name" : "Observation: Anthropometric Data (HDR CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-abdominalCircumference-hdr"
        },
        "name" : "Observation: Anthropometric Data (HDR CZ) - Abdominal Circumference",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-BMI-hdr"
        },
        "name" : "Observation: Anthropometric Data (HDR CZ) - BMI",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-chestCircumference-hdr"
        },
        "name" : "Observation: Anthropometric Data (HDR CZ) - Chest Circumference",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-headCircumference-hdr"
        },
        "name" : "Observation: Anthropometric Data (HDR CZ) - Head Circumference",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-height-hdr"
        },
        "name" : "Observation: Anthropometric Data (HDR CZ) - Height",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-infectious-contact-hdr"
        },
        "name" : "Observation: Infectious Contact (HDR CZ)",
        "description" : "Infectious Contact profile represents potential patient exposure to an agent (exposure source).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-sdoh-hdr"
        },
        "name" : "Observation: SDOH (HDR CZ)",
        "description" : "Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-travel-hdr"
        },
        "name" : "Observation: travel history (HDR CZ)",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch travel history.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-anthropometricdata-obl-hdr"
        },
        "name" : "Observations: Anthropometric Data obligations",
        "description" : "This profile defines obligations for an Anthropometric Data in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-ic-obl-hdr"
        },
        "name" : "Observations: Infectious Contact obligations",
        "description" : "This profile defines obligations for an Infectious Contact in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169"
        },
        "name" : "Organization-1",
        "description" : "An example of the organization of a provider",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1"
        },
        "name" : "Organization-L1",
        "description" : "A minimalist example of the organization of a healthcare provider for the purposes of the L1 HDR document.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/a4641bd0-34af-4038-a7db-872d08a54df9"
        },
        "name" : "Organization-L1-HOSP",
        "description" : "A minimalist example of a subordinate department within a hospital hierarchy for the purposes of the L1 HDR document.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/af2b3114-e872-43b9-9875-cceb39122f7f"
        },
        "name" : "Organization-L1-Odd",
        "description" : "A minimalist example of a subordinate department within a hospital hierarchy for the purposes of the L1 HDR document.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-organization-obl-hdr"
        },
        "name" : "Organization: Obligations",
        "description" : "This profile defines obligations for.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/RegisteringProviderExample"
        },
        "name" : "Organization: Registering healthcare provider example",
        "description" : "Example of registering healthcare provider",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/RegisteringProviderExample-gynecology"
        },
        "name" : "Organization: Registering healthcare provider example",
        "description" : "Example of registering healthcare provider",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/Immunization-CovidExample"
        },
        "name" : "Očkování Covid",
        "description" : "Očkování proti COVID-19 u pacienta Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/bloodcount-panel"
        },
        "name" : "Panel krevního obrazu",
        "description" : "Panel obsahující základní hematologické hodnoty",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Mracena"
        },
        "name" : "Patient - Mracena",
        "description" : "Patient, contact information and practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/3f85726c-ad2f-441b-89ce-100000000000"
        },
        "name" : "Patient-Novak-Petr",
        "description" : "Example of patient Petr Novak with identification by czech national identifiers (RID, RCIS), registrating healthcare provider and contact information",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/48a9d440-4194-42c1-87ad-b5a39020a4d0"
        },
        "name" : "Patient-Novak-Petr-L1",
        "description" : "Example of patient Petr Novak with identification by czech national identifiers (RID, RCIS), registrating healthcare provider and contact information",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-patient-obl-hdr"
        },
        "name" : "Patient: Obligations",
        "description" : "This profile defines obligations for an human Patient in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Organization-Pfizer"
        },
        "name" : "Pfizer výrobce vakcíny",
        "description" : "Organizace Pfizer s.r.o. vyrábějící vakcínu Comirnaty proti COVID-19",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceUseStatement"
          }
        ],
        "reference" : {
          "reference" : "DeviceUseStatement/DeviceUseStatement-Pacemaker"
        },
        "name" : "Použití kardiostimulátoru",
        "description" : "Záznam o implantaci kardiostimulátoru z důvodu bradykardie",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-100000000023"
        },
        "name" : "Pracovní zapojení",
        "description" : "Pacient pracuje na plný úvazek jako programátor.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/69d34ceb-b556-4f75-9e4c-9184fe8a10c5"
        },
        "name" : "Practitioner Role for L1 documentr",
        "description" : "Author of HDR document (phisician MUDr.Ivan Anděl)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitionerRole-obl-hdr"
        },
        "name" : "Practitioner Role: Obligations",
        "description" : "This profile defines obligations for a practitioner role in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Practitioner-2"
        },
        "name" : "Practitioner-2",
        "description" : "Practitioner id(KRZP)=987654321",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Practitioner-Admitter"
        },
        "name" : "Practitioner-Admitter",
        "description" : "Participant Admitter HDR",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a"
        },
        "name" : "Practitioner-Author",
        "description" : "Participant Referrer HDR",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/2b7e9637-5018-4542-9faf-d5abdee7b849"
        },
        "name" : "Practitioner-Author-detail",
        "description" : "practitioner's detail",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/e234a53a-4e0d-4fb8-9403-e0e324a50f64"
        },
        "name" : "Practitioner-Author-L1",
        "description" : "Author of hospital discharge report for document L1",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Practitioner-L1"
        },
        "name" : "Practitioner-L1",
        "description" : "Practitioner id(KRZP)=987645454",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Practitioner-Referrer"
        },
        "name" : "Practitioner-Referrer",
        "description" : "Participant Referrer HDR",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/Practitioner-Referrer-detail"
        },
        "name" : "Practitioner-Referrer-detail",
        "description" : "practitioner's detail",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/860c684f-aba1-40d9-94cf-721d70237b52"
        },
        "name" : "Practitioner-UZV",
        "description" : "Participant UZV HDR",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitioner-obl-hdr"
        },
        "name" : "Practitioner: Obligations",
        "description" : "This profile defines obligations for a practitioner in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/practitionerrole1"
        },
        "name" : "PractitionerRole1",
        "description" : "General practitioner's office",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-procedure-hdr"
        },
        "name" : "Procedure (HDR CZ)",
        "description" : "This profile represents the constraints applied to the Procedure resource by this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-procedure-obl-hdr"
        },
        "name" : "Procedure: Obligations",
        "description" : "This profile defines obligations for a procedure in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf"
        },
        "name" : "Propouštěcí zpráva",
        "description" : "Example Composition for Hospital Discharge Report for patient Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/701f51d5-78bf-428e-a6b5-349c2614ce07"
        },
        "name" : "Propouštěcí zpráva",
        "description" : "Example Composition for Hospital Discharge Report for patient Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c03b"
        },
        "name" : "Propouštěcí zpráva",
        "description" : "Example Composition for Hospital Discharge Report for patient Novák Petr",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c035"
        },
        "name" : "Propouštěcí zpráva z nemocnice",
        "description" : "Sample composition of a discharge report for patient Novák Petr for the purposes of an L1 document. This is the minimum possible list of data for compiling an L1 document for a hospital discharge report.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/relatedPersonRelationshipTypes-eu-hdr"
        },
        "name" : "Related Person Relationship Types (HDR)",
        "description" : "HDR related person relationship types value set.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-relatedPerson-hdr"
        },
        "name" : "Related Person: HDR (CZ)",
        "description" : "Czech profile for related person.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-relatedPerson-obl-hdr"
        },
        "name" : "Related Person: Obligations",
        "description" : "This profile defines obligations for a related person in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/Location-5"
        },
        "name" : "Sample Czech Location 1",
        "description" : "Example instance of a location conforming to the CZ_LocationCore profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/sample-cz-location-2"
        },
        "name" : "Sample Czech Location 2",
        "description" : "Example instance of a location conforming to the CZ_LocationCore profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/cz-Location-Chrudim-Chir1"
        },
        "name" : "Sample Czech Location 2",
        "description" : "Example instance of a location conforming to the CZ_LocationCore profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/cz-Location-Chrudim-ChirJIP"
        },
        "name" : "Sample Czech Location 2",
        "description" : "Example instance of a location conforming to the CZ_LocationCore profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/sample-cz-location-3"
        },
        "name" : "Sample Czech Location 3",
        "description" : "Example instance of a location conforming to the CZ_LocationCore profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/sample-cz-location-4"
        },
        "name" : "Sample Czech Location 4",
        "description" : "Example instance of a location conforming to the CZ_LocationCore profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab"
        },
        "name" : "Signature of image order",
        "description" : "Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb"
        },
        "name" : "Signature of image order",
        "description" : "Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-100000000025"
        },
        "name" : "Sociální síť",
        "description" : "Pacient má aktivní sociální síť a pravidelně se setkává s přáteli.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Sova"
        },
        "name" : "Sova",
        "description" : "Practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Sovak"
        },
        "name" : "Sovak",
        "description" : "Practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-100000000022"
        },
        "name" : "Společenské uplatnění",
        "description" : "Pacient je aktivní v komunitních aktivitách a dobrovolnictví.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-100000000021"
        },
        "name" : "Stav při propuštění",
        "description" : "Hodnocení celkového klinického stavu pacienta při propuštění",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Flag"
          }
        ],
        "reference" : {
          "reference" : "Flag/5a17a710-193e-4490-a627-7202925aa56e"
        },
        "name" : "Střední podvýživa",
        "description" : "Střední podvýživa – doporučení nutriční terapie u pacienta.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/temporarySystem-hdr-cz"
        },
        "name" : "Temporary HDR Code System",
        "description" : "This is a temporary code system defined to collect concepts expected required by this project, but for which international coded concepts have not been identified yet.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/plt-result"
        },
        "name" : "Trombocyty",
        "description" : "Příklad pro HDR - Počet trombocytů v krvi",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/e15aeeaf-e288-404c-9704-9c8f0b2d4e3a"
        },
        "name" : "UZV - Novák Petr",
        "description" : "Czech HDR - example of an ultrasound observation for Novák Petr",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/3f85726c-ad2f-441b-89ce-100000000027"
        },
        "name" : "Vzdělání",
        "description" : "Pacient má vysokoškolské vzdělání v oboru informatiky.",
        "exampleCanonical" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/Specimen-EDTA-1"
        },
        "name" : "Vzorek krve – EDTA",
        "description" : "Venous blood specimen",
        "exampleBoolean" : true
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index-cs.html"
            }
          ],
          "nameUrl" : "index-cs.html",
          "title" : "Domovská stránka",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content.html"
            }
          ],
          "nameUrl" : "scope-and-content.html",
          "title" : "Scope and content",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content-cs.html"
            }
          ],
          "nameUrl" : "scope-and-content-cs.html",
          "title" : "Oblasti a obsah",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background.html"
            }
          ],
          "nameUrl" : "background.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background-cs.html"
            }
          ],
          "nameUrl" : "background-cs.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors.html"
            }
          ],
          "nameUrl" : "authors.html",
          "title" : "Authors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-cs.html"
            }
          ],
          "nameUrl" : "authors-cs.html",
          "title" : "Autoři",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright.html"
            }
          ],
          "nameUrl" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-cs.html"
            }
          ],
          "nameUrl" : "copyright-cs.html",
          "title" : "Autorská práva",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies.html"
            }
          ],
          "nameUrl" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-cs.html"
            }
          ],
          "nameUrl" : "dependencies-cs.html",
          "title" : "Závislosti",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples-cs.html"
            }
          ],
          "nameUrl" : "examples-cs.html",
          "title" : "Příklady",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models.html"
            }
          ],
          "nameUrl" : "logical-models.html",
          "title" : "Logical models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models-cs.html"
            }
          ],
          "nameUrl" : "logical-models-cs.html",
          "title" : "Datová sada - logické modely CZ",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map.html"
            }
          ],
          "nameUrl" : "model-map.html",
          "title" : "Model maps",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map-cs.html"
            }
          ],
          "nameUrl" : "model-map-cs.html",
          "title" : "Mapování logického modelu",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "obligations.html"
            }
          ],
          "nameUrl" : "obligations.html",
          "title" : "Obligations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "obligations-cs.html"
            }
          ],
          "nameUrl" : "obligations-cs.html",
          "title" : "Obligations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-cs.html"
            }
          ],
          "nameUrl" : "downloads-cs.html",
          "title" : "Ke stažení",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "implementation-notes.html"
            }
          ],
          "nameUrl" : "implementation-notes.html",
          "title" : "Implementation notes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "implementation-notes-cs.html"
            }
          ],
          "nameUrl" : "implementation-notes-cs.html",
          "title" : "Implementační poznámky",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Artifacts",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "HospitalDischargeReport-map.html"
            }
          ],
          "nameUrl" : "HospitalDischargeReport-map.html",
          "title" : "HospitalDischargeReport Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Header-map.html"
            }
          ],
          "nameUrl" : "Header-map.html",
          "title" : "Header Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Subject-map.html"
            }
          ],
          "nameUrl" : "Subject-map.html",
          "title" : "Subject Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "InPatientEncounter-map.html"
            }
          ],
          "nameUrl" : "InPatientEncounter-map.html",
          "title" : "InPatientEncounter Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "AdmissionEvaluation-map.html"
            }
          ],
          "nameUrl" : "AdmissionEvaluation-map.html",
          "title" : "AdmissionEvaluation Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "ObjectiveFindings-map.html"
            }
          ],
          "nameUrl" : "ObjectiveFindings-map.html",
          "title" : "ObjectiveFindings Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "FunctionalStatus-map.html"
            }
          ],
          "nameUrl" : "FunctionalStatus-map.html",
          "title" : "FunctionalStatus Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "HospitalStay-map.html"
            }
          ],
          "nameUrl" : "HospitalStay-map.html",
          "title" : "HospitalStay Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "PatientHistory-map.html"
            }
          ],
          "nameUrl" : "PatientHistory-map.html",
          "title" : "PatientHistory Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Alerts-map.html"
            }
          ],
          "nameUrl" : "Alerts-map.html",
          "title" : "Alerts Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "AdvanceDirectives-map.html"
            }
          ],
          "nameUrl" : "AdvanceDirectives-map.html",
          "title" : "AdvanceDirectives Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "PlanOfCare-map.html"
            }
          ],
          "nameUrl" : "PlanOfCare-map.html",
          "title" : "PlanOfCare Relationships",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "MedicationSummary-map.html"
            }
          ],
          "nameUrl" : "MedicationSummary-map.html",
          "title" : "MedicationSummary Relationships",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
