# A.1.9 - Digital signature - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.9 - Digital signature**

## Logical Model: A.1.9 - Digital signature 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/digitalSignatureCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnDigitalSignatureCz |

 
Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/digitalSignatureCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-digitalSignatureCz.csv), [Excel](StructureDefinition-digitalSignatureCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "digitalSignatureCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/digitalSignatureCz",
  "version" : "0.1.0",
  "name" : "LogEnDigitalSignatureCz",
  "title" : "A.1.9 - Digital signature",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/digitalSignatureCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "digitalSignatureCz",
        "path" : "digitalSignatureCz",
        "short" : "A.1.9 - Digital signature",
        "definition" : "Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a"
      },
      {
        "id" : "digitalSignatureCz.digitalSignature",
        "path" : "digitalSignatureCz.digitalSignature",
        "short" : "A.1.9.1 - Electronic signature or document seal",
        "definition" : "Electronic signature or document seal.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "digitalSignatureCz.timestamp",
        "path" : "digitalSignatureCz.timestamp",
        "short" : "A.1.9.2 - Electronic time stamp",
        "definition" : "Electronic time stamp",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
