# Organization: Obligations - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Organization: Obligations**

## Resource Profile: Organization: Obligations 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-organization-obl-hdr | *Version*:0.1.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_OrganizationObligationsHdr |

 
This profile defines obligations for. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-organization-obl-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-organization-obl-hdr.csv), [Excel](StructureDefinition-cz-organization-obl-hdr.xlsx), [Schematron](StructureDefinition-cz-organization-obl-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-organization-obl-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core|2.0.0-ballot"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-organization-obl-hdr",
  "version" : "0.1.0",
  "name" : "CZ_OrganizationObligationsHdr",
  "title" : "Organization: Obligations",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines obligations for.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.identifier"
      },
      {
        "id" : "Organization.identifier:KRPZS",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "KRPZS"
      },
      {
        "id" : "Organization.identifier:KP",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "KP"
      },
      {
        "id" : "Organization.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.name"
      },
      {
        "id" : "Organization.telecom",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.telecom"
      },
      {
        "id" : "Organization.address",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.address"
      }
    ]
  }
}

```
