# Flag (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Flag (HDR CZ)**

## Resource Profile: Flag (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_FlagHdr |

 
This profile constrains the Flag resource to represent alerts or warnings in FHIR for the purpose of this project. 

**Usages:**

* Derived from this Profile: [Flag Obligations (HDR CZ)](StructureDefinition-cz-flag-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Examples for this Profile: [Flag/5a17a710-193e-4490-a627-7202925aa56e](Flag-5a17a710-193e-4490-a627-7202925aa56e.md) and [Flag/Flag1](Flag-Flag1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-flag-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-flag-hdr.csv), [Excel](StructureDefinition-cz-flag-hdr.xlsx), [Schematron](StructureDefinition-cz-flag-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-flag-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr",
  "version" : "0.1.0",
  "name" : "CZ_FlagHdr",
  "title" : "Flag (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Flag resource to represent alerts or warnings in FHIR for the purpose of this project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Flag",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Flag",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Flag.extension",
        "path" : "Flag.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Flag.extension:flagDetailExt",
        "path" : "Flag.extension",
        "sliceName" : "flagDetailExt",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/flag-detail|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Flag.extension:flagPriorityExt",
        "path" : "Flag.extension",
        "sliceName" : "flagPriorityExt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/flag-priority|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Flag.status",
        "path" : "Flag.status",
        "short" : "Alert status"
      },
      {
        "id" : "Flag.code",
        "path" : "Flag.code",
        "short" : "Coded or textual message to display to user."
      },
      {
        "id" : "Flag.subject",
        "path" : "Flag.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      }
    ]
  }
}

```
