# DeviceUseStatement (HDR) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **DeviceUseStatement (HDR)**

## Resource Profile: DeviceUseStatement (HDR) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_DeviceUseStatementHdr |

 
This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. 

**Usages:**

* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [DeviceUseStatement/DeviceUseStatement-Pacemaker](DeviceUseStatement-DeviceUseStatement-Pacemaker.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-deviceUseStatement-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-deviceUseStatement-hdr.csv), [Excel](StructureDefinition-cz-deviceUseStatement-hdr.xlsx), [Schematron](StructureDefinition-cz-deviceUseStatement-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-deviceUseStatement-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/DeviceUseStatement-uv-ips|2.0.0"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr",
  "version" : "0.1.0",
  "name" : "CZ_DeviceUseStatementHdr",
  "title" : "DeviceUseStatement (HDR)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceUseStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceUseStatement",
        "path" : "DeviceUseStatement"
      },
      {
        "id" : "DeviceUseStatement.text",
        "path" : "DeviceUseStatement.text",
        "short" : "Device usage description"
      },
      {
        "id" : "DeviceUseStatement.subject",
        "path" : "DeviceUseStatement.subject",
        "definition" : "The patient using the device.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core|2.0.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.subject.reference",
        "path" : "DeviceUseStatement.subject.reference",
        "min" : 1
      },
      {
        "id" : "DeviceUseStatement.timing[x]",
        "path" : "DeviceUseStatement.timing[x]",
        "min" : 1
      },
      {
        "id" : "DeviceUseStatement.timing[x].extension:data-absent-reason",
        "path" : "DeviceUseStatement.timing[x].extension",
        "sliceName" : "data-absent-reason",
        "definition" : "Provides a reason why the timing is missing.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.device",
        "path" : "DeviceUseStatement.device",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.eu/fhir/hdr/StructureDefinition/device-eu-hdr"]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.reasonCode",
        "path" : "DeviceUseStatement.reasonCode",
        "short" : "Why is used (code)"
      },
      {
        "id" : "DeviceUseStatement.reasonReference",
        "path" : "DeviceUseStatement.reasonReference",
        "short" : "Why is used (details)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/hdr/StructureDefinition/condition-eu-hdr",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/Media",
              "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.bodySite",
        "path" : "DeviceUseStatement.bodySite",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      }
    ]
  }
}

```
