# Condition (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Condition (HDR CZ)**

## Resource Profile: Condition (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ConditionHdr |

 
This profile represents the constraint applied to the Condition in the scope of this guide. It supports the Diagnostic summary part of the eHN data model adding two additional categories: First category distinguishes conditions present at admission and acquired during hospital stay, while second category is used to indicate impact of the condition to the treatment during hospital stay (treated, untreated). 

**Usages:**

* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Care Plan (HDR CZ)](StructureDefinition-cz-carePlan-hdr.md), [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md) and [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)
* Examples for this Profile: [Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md), [Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md), [Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md), [Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md)...Show 10 more,[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)and[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-condition-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-condition-hdr.csv), [Excel](StructureDefinition-cz-condition-hdr.xlsx), [Schematron](StructureDefinition-cz-condition-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-condition-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/condition-eu-hdr"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr",
  "version" : "0.1.0",
  "name" : "CZ_ConditionHdr",
  "title" : "Condition (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraint applied to the Condition in the scope of this guide. It supports the Diagnostic summary part of the eHN data model adding two additional categories: First category distinguishes conditions present at admission and acquired during hospital stay, while second category is used to indicate impact of the condition to the treatment during hospital stay (treated, untreated).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition.text",
        "path" : "Condition.text",
        "definition" : "Human readable specification of the problem. This is a general notes/comments entry for description of the problem, its diagnosis and prognosis."
      },
      {
        "id" : "Condition.extension",
        "path" : "Condition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.extension:bodySite",
        "path" : "Condition.extension",
        "sliceName" : "bodySite",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/bodySite|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:bodySite.value[x]",
        "path" : "Condition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/laboratory/StructureDefinition/BodyStructure-eu-lab"
            ]
          }
        ]
      },
      {
        "id" : "Condition.identifier",
        "path" : "Condition.identifier",
        "definition" : "Globally unique identifier of this problem which remain constant as the resource is updated and propagates from server to server."
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "definition" : "The problem status describes the condition of the problem:\n\r\n1.\tActive problems are problems of which the patient experiences symptoms or for which evidence exists.\n\r\n2.\tIf condition is abated, then clinicalStatus must be either inactive, resolved, or remission. \n\r\n3.\tProblems with the status 'Inactive' refer to problems that don't affect the patient anymore or that of which there is no evidence of existence anymore.",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-clinical"
        }
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-ver-status"
        }
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "category codes",
        "definition" : "Slices per type of classificaton",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Condition.category:poa",
        "path" : "Condition.category",
        "sliceName" : "poa",
        "short" : "POA, HAC, NA",
        "definition" : "Present on admission, Hospital acquired condition, Not applicable or unknown",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hdr/ValueSet/eHDSIConditionPOA"
        }
      },
      {
        "id" : "Condition.category:treated",
        "path" : "Condition.category",
        "sliceName" : "treated",
        "short" : "Treated or untreated",
        "definition" : "Class of the problem (treated, other) in relation to the hospital encounter. Treated problems were treated or affected provisioning of care (diagnostics, therapy, nursing, monitoring) during the hospital encounter. At least one problem should be marked as Treated. Other problems are recorded only if they are important for continuity of care (after discharge).",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hdr/ValueSet/eHDSITreatmentClass"
        }
      },
      {
        "id" : "Condition.severity",
        "path" : "Condition.severity",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-severity"
        }
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "definition" : "The problem code specifies the problem. Depending on the setting, different code systems can be used. The ProblemCodelist provides an overview of the possible code systems.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Valueset to describe the actual problem experienced by the patient",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/condition-eu-hdr"
        }
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Condition.subject.reference",
        "path" : "Condition.subject.reference",
        "min" : 1
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.onset[x]:onsetDateTime",
        "path" : "Condition.onset[x]",
        "sliceName" : "onsetDateTime",
        "definition" : "Onset of the symptom, complaint, functional limitation, complication or date of diagnosis. A ‘vague’ date, such as only the year or the month and the year, is permitted.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Condition.abatement[x]",
        "path" : "Condition.abatement[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.abatement[x]:abatementDateTime",
        "path" : "Condition.abatement[x]",
        "sliceName" : "abatementDateTime",
        "definition" : "The date or estimated date that the condition resolved or went into remission. A ‘vague’ date, such as only the year or the month and the year, is permitted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Condition.stage",
        "path" : "Condition.stage",
        "short" : "Stage/grade"
      },
      {
        "id" : "Condition.stage.summary",
        "path" : "Condition.stage.summary",
        "short" : "Most recent Stage Group"
      },
      {
        "id" : "Condition.stage.assessment",
        "path" : "Condition.stage.assessment",
        "definition" : "Reference to the evidence on which the staging assessment is based."
      },
      {
        "id" : "Condition.stage.type",
        "path" : "Condition.stage.type",
        "short" : "Staging system used."
      },
      {
        "id" : "Condition.note",
        "path" : "Condition.note",
        "definition" : "Comment by the one who determined or updated the Problem."
      }
    ]
  }
}

```
