# Composition (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition (HDR CZ)**

## Resource Profile: Composition (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_CompositionHdr |

 
This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. 

### Content (cs)

#### Composition (HDR CZ)

**Resource Composition (HDR CZ)** popisuje strukturu a obsahovou kostru propouštěcí zprávy. Je hlavním dokumentovým prvkem, který určuje formální hlavičku zprávy, identifikaci, status, datum a čas vytvoření, autora a příjemce. Obsahuje odkaz na pacienta, kontext hospitalizace a všechny obsahové sekce propouštěcí zprávy včetně narativního textu a vazeb na detailní zdroje.

Slouží k jednotnému a přehlednému zachycení informací o průběhu hospitalizace, provedených výkonech, zjištěných nálezech, podané léčbě, stavu při propuštění a doporučeních pro další péči.

-------

**Usages:**

* Derived from this Profile: [Composition: Obligations](StructureDefinition-cz-composition-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Examples for this Profile: [Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c035](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c035.md), [Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c03b](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.md), [Composition/701f51d5-78bf-428e-a6b5-349c2614ce07](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md) and [Composition/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf](Composition-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-composition-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-composition-hdr.csv), [Excel](StructureDefinition-cz-composition-hdr.xlsx), [Schematron](StructureDefinition-cz-composition-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-composition-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/composition-eu-hdr"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr",
  "version" : "0.1.0",
  "name" : "CZ_CompositionHdr",
  "title" : "Composition (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Hospital Discharge Report composition",
        "definition" : "Hospital Discharge Report composition. \r\nA composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained."
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.extension:basedOn",
        "path" : "Composition.extension",
        "sliceName" : "basedOn",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/event-basedOn|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:basedOn.value[x]",
        "path" : "Composition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Resource",
              "http://hl7.org/fhir/StructureDefinition/ServiceRequest"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm",
        "path" : "Composition.extension",
        "sliceName" : "presentedForm",
        "short" : "Presented form",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/presentedForm"]
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].contentType",
        "path" : "Composition.extension.value[x].contentType",
        "example" : [
          {
            "label" : "pdf",
            "valueCode" : "application/pdf"
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].data",
        "path" : "Composition.extension.value[x].data",
        "short" : "B64 in-line data"
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].url",
        "path" : "Composition.extension.value[x].url",
        "short" : "URL of the document"
      },
      {
        "id" : "Composition.extension:compositionVersionR5",
        "path" : "Composition.extension",
        "sliceName" : "compositionVersionR5",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Composition.version"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:compositionVersionR5.value[x]",
        "path" : "Composition.extension.value[x]",
        "short" : "Business version"
      },
      {
        "id" : "Composition.extension:information-recipient",
        "path" : "Composition.extension",
        "sliceName" : "information-recipient",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/StructureDefinition/information-recipient|1.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:information-recipient.value[x]",
        "path" : "Composition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "HDR business identifier"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "HDR status"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Kind of composition (\"Hospital Discharge Report\")",
        "definition" : "Specifies that this composition refer to a Hospital Discharge Report",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34105-7",
              "display" : "Hospital Discharge summary"
            }
          ]
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "definition" : "Who or what the composition is about. \r\nIn general a composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).\r\nFor the hdr the subject is always the patient.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "HDR date"
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored the Hospital Discharge Report",
        "definition" : "Identifies who is responsible for the information in the Hospital Discharge Report, not necessarily who typed it in.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Hospital Discharge Report",
        "definition" : "Official human-readable label for the composition.\r\n\r\nFor this document should be \"Hospital Discharge Report\" or any equivalent translation"
      },
      {
        "id" : "Composition.attester.mode",
        "path" : "Composition.attester.mode",
        "short" : "The type of attestation"
      },
      {
        "id" : "Composition.attester.time",
        "path" : "Composition.attester.time",
        "short" : "When the composition was attested."
      },
      {
        "id" : "Composition.attester.party",
        "path" : "Composition.attester.party",
        "short" : "Who attested the composition.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sections composing the Hospital Discharge Report",
        "definition" : "The root of the sections that make up the Hospital Discharge Report composition.",
        "min" : 1
      },
      {
        "id" : "Composition.section.author",
        "path" : "Composition.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation",
        "path" : "Composition.section",
        "sliceName" : "sectionAdmissionEvaluation",
        "comment" : "Admission evaluation should be reported only exceptionally, if it is relevant to ensure continuity of care.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67851-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Objective findings",
        "definition" : "Findings made by healthcare practitioner",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionAnthropometry",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionAnthropometry",
        "short" : "Anthropometric observations",
        "definition" : "Anthropometric Observations sub-section",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionAnthropometry.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "248326004"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionAnthropometry.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Entry used to represent anthropometric measurements",
        "definition" : "It describes findings from anthropometric measurements of the patient, such as height, weight, BMI, head circumference, chest circumference, abdominal circumference",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-abdominalCircumference-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-height-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-weight-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-BMI-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-headCircumference-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-chestCircumference-hdr",
              "http://hl7.org/fhir/StructureDefinition/Observation"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionAnthropometry.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionAnthropometry.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionVitalSigns",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionVitalSigns",
        "short" : "Vital signs",
        "definition" : "The Vital signs section includes blood pressure, body temperature, heart rate, and respiratory rate. It may also include other clinical findings, such as height, weight, body mass index, head circumference, and pulse oximetry. In particular, notable vital signs or physical findings such as the most recent, maximum and/or minimum, baseline, or relevant trends may be included",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionVitalSigns.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8716-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionVitalSigns.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Entry used to represent vital sign measurements",
        "definition" : "It describes findings from vital sign measurements of the patient. Profiles to express structured vital sign measurements will be specified by future versions of this guide.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionVitalSigns.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionVitalSigns.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionPhysicalExamination",
        "path" : "Composition.section.section",
        "sliceName" : "sectionPhysicalExamination",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionPhysicalExamination.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Somatické vyšetření"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionPhysicalExamination.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "425044008",
              "display" : "Physical exam section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionPhysicalExamination.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Optional entry used to represent physical examination findings",
        "definition" : "It describes findings from physical examination of the patient. Profiles to express structured physical examination findings will be specified by future versions of this guide.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionFunctionalStatus",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionFunctionalStatus",
        "short" : "Functional status",
        "definition" : "The functional status section shall contain a narrative description of capability of the patient to perform acts of daily living, including possible needs of the patient to be continuously assessed by third parties. The invalidity status may in fact influence decisions about how to administer treatments.\r\nProfiles to express disabilities and functional assessments will be specified by future versions of this guide.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionFunctionalStatus.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47420-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionFunctionalStatus.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Optional entry used to represent disabilities and functional assessments",
        "definition" : "It describes capabilities of the patient to perform acts of daily living, including possible needs of the patient to be continuously assessed by third parties. The invalidity status may in fact influence decisions about how to administer treatments.\r\nProfiles to express disabilities and functional assessments will be specified by future versions of this guide.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr",
              "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionFunctionalStatus.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdmissionEvaluation.section:sectionFunctionalStatus.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPhysicalFindings",
        "path" : "Composition.section",
        "sliceName" : "sectionPhysicalFindings",
        "short" : "Physical findings",
        "definition" : "Physical findings",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPhysicalFindings.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPhysicalFindings.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29545-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPhysicalFindings.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPhysicalFindings.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPhysicalExamination",
        "path" : "Composition.section",
        "sliceName" : "sectionPhysicalExamination",
        "short" : "Physical examination",
        "definition" : "Physical examination is the process of evaluating objective anatomical findings.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPhysicalExamination.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPhysicalExamination.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "55286-9"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPhysicalExamination.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPhysicalExamination.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionVitalSigns",
        "path" : "Composition.section",
        "sliceName" : "sectionVitalSigns",
        "short" : "Vital signs",
        "definition" : "The Vital signs section includes blood pressure, body temperature, heart rate, and respiratory rate. It may also include other clinical findings, such as height, weight, body mass index, head circumference, and pulse oximetry. In particular, notable vital signs or physical findings such as the most recent, maximum and/or minimum, baseline, or relevant trends may be included",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionVitalSigns.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionVitalSigns.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8716-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionVitalSigns.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/vitalsigns"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionVitalSigns.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionVitalSigns.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus",
        "path" : "Composition.section",
        "sliceName" : "sectionFunctionalStatus",
        "short" : "Functional status",
        "definition" : "The functional status section shall contain a narrative description of capability of the patient to perform acts of daily living, including possible needs of the patient to be continuously assessed by third parties. The invalidity status may in fact influence decisions about how to administer treatments.\r\nProfiles to express disabilities and functional assessments will be specified by future versions of this guide.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47420-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.entry",
        "path" : "Composition.section.entry",
        "short" : "Optional entry used to represent disabilities and functional assessments",
        "definition" : "It describes capabilities of the patient to perform acts of daily living, including possible needs of the patient to be continuously assessed by third parties. The invalidity status may in fact influence decisions about how to administer treatments.\r\nProfiles to express disabilities and functional assessments will be specified by future versions of this guide.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr",
              "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAllergies",
        "path" : "Composition.section",
        "sliceName" : "sectionAllergies",
        "short" : "Allergies and Intolerances Section",
        "definition" : "This section documents the relevant allergies or intolerances (conditions) for that patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy.\r\nAt a minimum, it should list currently active and any relevant historical allergies and adverse reactions.\r\nIf no information about allergies is available, or if no allergies are known this should be clearly documented in the section.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAllergies.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAllergies.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48765-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAllergies.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Relevant allergies or intolerances (conditions) for that patient.",
        "definition" : "It lists the relevant allergies or intolerances (conditions) for that patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy.\r\nAt a minimum, it should list currently active and any relevant historical allergies and adverse reactions.\r\n This entry shall be used to document that no information about allergies is available, or that no allergies are known .",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.entry:allergyIntolerance",
        "path" : "Composition.section.entry",
        "sliceName" : "allergyIntolerance",
        "short" : "Allergy entry",
        "definition" : "Allergy entry",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAlert",
        "path" : "Composition.section",
        "sliceName" : "sectionAlert",
        "short" : "Alert Section",
        "definition" : "// SHORT\n    A warning, other than included in allergies.\n    The warning can be entered in code there are codes for frequently used alerts but seeing the dynamic nature of the warnings, these alerts will often be entered as free text.\n    Any clinical information that is imperative to know so that the life or health of the patient does not come under threat.\n    Example 1: the patient has a rare disease that requires special treatment\n    Example 2: Airway Alert / Difficult Intubation\n    Example 3: Diagnoses such as malignant hyperthermia, porphyria, and bleeding disorders; special treatments like anticoagulants or immunosuppressants; implanted devices.\n    Example 4: transplanted organs illustrate other information that has to be taken into account in a healthcare contact.\n    Example 5: participation in a clinical trial that has to be taken into account in a healthcare contact.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAlert.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAlert.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "104605-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAlert.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Alerts",
        "definition" : "Alerts"
      },
      {
        "id" : "Composition.section:sectionAlert.entry:flag",
        "path" : "Composition.section.entry",
        "sliceName" : "flag",
        "short" : "Flags",
        "definition" : "Flags",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Flag"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse",
        "path" : "Composition.section",
        "sliceName" : "sectionHospitalCourse",
        "short" : "Significant information about course of hospital stay",
        "definition" : "This section includes basic information about hospital staty (encounter), diagnostic summary in narrative form, pharmacotherapy, major procedures, medical devices, significant findings during hospital stay and clinical synthesis.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8648-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionDiagnosticSummary",
        "path" : "Composition.section",
        "sliceName" : "sectionDiagnosticSummary",
        "short" : "Problem specification in narrative form",
        "definition" : "All problems/diagnoses that affect care during the inpatient case or are important to be recorded to ensure continuity of care. The diagnostic summary differentiates, in accordance with the international recommendation, between problems treated during hospital stay and other (untreated) problems. Treated problems are problems that were the subject of diagnostics, therapy, nursing, or (continuous) monitoring during the hospitalisation. Furthermore problems could be divided into three categories: problems present on admission (POA), conditions acquired during hospital stay (HAC) and problems that cannot be classified as being of any of the two (N/A). The diagnostic summary contains all conditions as they were recognised at the end of hospitalisation, after all examinations. This section contains concise, well specified, codeable, summary of problems. Problems are ordered by importance (main problems first) during hospital stay. Description of the problem might be completed with additional details in the medical history section and/or in the Synthesis section.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDiagnosticSummary.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionDiagnosticSummary.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11535-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDiagnosticSummary.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDiagnosticSummary.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDiagnosticSummary.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionSignificantProcedures",
        "path" : "Composition.section",
        "sliceName" : "sectionSignificantProcedures",
        "short" : "Significant procedures",
        "definition" : "Significant surgical and non-surgical procedures performed during hospitalisation which are significant for continuity of care, e.g. surgeries and other \"instrumental\"interventions (endoscopic, intravascular), chemotherapy, radiotherapy, purification methods (dialysis, hemoperfusion), circulation support methods (counterpulsation, etc.), administration of blood derivatives or others.\r\nThis section does not include purely diagnostic procedures (MRI, CT, etc.). If no significant performance has been performed, this fact must be explicitly stated using the IPS Absent and Unknown Data.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionSignificantProcedures.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionSignificantProcedures.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10185-7"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionSignificantProcedures.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionSignificantProcedures.section",
        "path" : "Composition.section.section",
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionSignificantProcedures.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionMedicalDevices",
        "path" : "Composition.section",
        "sliceName" : "sectionMedicalDevices",
        "short" : "Medical devices and implants",
        "definition" : "Implants and used medical devices that affected or may affect the provision of health services (diagnosis and treatment). Also medical devices explanted, or its use was stopped during hospitalisation. If the section is blank, the reason must be explicitly stated using the IPS Absent and Unknown Data coding system.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "57080-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.section",
        "path" : "Composition.section.section",
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPharmacotherapy",
        "path" : "Composition.section",
        "sliceName" : "sectionPharmacotherapy",
        "short" : "Pharmacotherapy",
        "definition" : "Selected drug treatment during hospitalisation. Medicinal products that were administered during hospitalisation and whose administration has already been discontinued before discharge. Only products which are important for continuity of care (antibiotics other than completely routine, corticosteroids in high doses, etc.) will be listed. Products which administration will continue after discharge will be also recorder in the Medication summary section.\nMedicinal products, the administration of which was started during hospitalisation but is also recommended after discharge, will be listed in the summary table in the recommendation section.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPharmacotherapy.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPharmacotherapy.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "87232-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPharmacotherapy.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationDispense-hdr",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPharmacotherapy.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPharmacotherapy.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionSignificantResults",
        "path" : "Composition.section",
        "sliceName" : "sectionSignificantResults",
        "short" : "Significant Observation Results",
        "definition" : "Results of significant functional, diagnostic, and imaging examinations to ensure continuity of care, performed during hospitalisation. Results of examinations ordered but not yet delivered should be presented separately from results already delivered.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionSignificantResults.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionSignificantResults.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "30954-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionSignificantResults.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "significant results",
        "definition" : "significant results",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionSignificantResults.entry:labResult",
        "path" : "Composition.section.entry",
        "sliceName" : "labResult",
        "short" : "Laboratory Result",
        "definition" : "Laboratory Result",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionSignificantResults.entry:radResult",
        "path" : "Composition.section.entry",
        "sliceName" : "radResult",
        "short" : "Radiology Result",
        "definition" : "Radiology Result",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/img/StructureDefinition/cz-observation-result-imaging"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionSignificantResults.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionSignificantResults.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionSynthesis",
        "path" : "Composition.section",
        "sliceName" : "sectionSynthesis",
        "short" : "Synthesis",
        "definition" : "This section provides clinical synthesis (e.g. description of reasons and course of hospital stay) clustered by managed conditions. Clinical synthesis may include clinical reasoning (differential diagnostics, explanation of clinical context) in clinically complex conditions.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionSynthesis.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionSynthesis.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67781-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionSynthesis.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionSynthesis.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails",
        "path" : "Composition.section",
        "sliceName" : "sectionDischargeDetails",
        "short" : "Discharge details",
        "definition" : "The hospital discharge status or disposition of the patient having a hospitalization.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8650-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Objective findings",
        "definition" : "Findings made by healthcare practitioner",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionAnthropometry",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionAnthropometry",
        "short" : "Anthropometric observations",
        "definition" : "Anthropometric Observations sub-section",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionAnthropometry.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "248326004"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionAnthropometry.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Entry used to represent anthropometric measurements",
        "definition" : "It describes findings from anthropometric measurements of the patient, such as height, weight, BMI, head circumference, chest circumference, abdominal circumference",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-abdominalCircumference-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-height-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-weight-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-BMI-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-headCircumference-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-chestCircumference-hdr",
              "http://hl7.org/fhir/StructureDefinition/Observation"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionAnthropometry.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionAnthropometry.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionVitalSigns",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionVitalSigns",
        "short" : "Vital signs",
        "definition" : "The Vital signs section includes blood pressure, body temperature, heart rate, and respiratory rate. It may also include other clinical findings, such as height, weight, body mass index, head circumference, and pulse oximetry. In particular, notable vital signs or physical findings such as the most recent, maximum and/or minimum, baseline, or relevant trends may be included",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionVitalSigns.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8716-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionVitalSigns.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Entry used to represent vital sign measurements",
        "definition" : "It describes findings from vital sign measurements of the patient. Profiles to express structured vital sign measurements will be specified by future versions of this guide.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionVitalSigns.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionVitalSigns.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionPhysicalExamination",
        "path" : "Composition.section.section",
        "sliceName" : "sectionPhysicalExamination",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionPhysicalExamination.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Somatické vyšetření"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionPhysicalExamination.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "425044008",
              "display" : "Physical exam section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionPhysicalExamination.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Optional entry used to represent physical examination findings",
        "definition" : "It describes findings from physical examination of the patient. Profiles to express structured physical examination findings will be specified by future versions of this guide.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionFunctionalStatus",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionFunctionalStatus",
        "short" : "Functional status",
        "definition" : "The functional status section shall contain a narrative description of capability of the patient to perform acts of daily living, including possible needs of the patient to be continuously assessed by third parties. The invalidity status may in fact influence decisions about how to administer treatments.\r\nProfiles to express disabilities and functional assessments will be specified by future versions of this guide.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionFunctionalStatus.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47420-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionFunctionalStatus.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Optional entry used to represent disabilities and functional assessments",
        "definition" : "It describes capabilities of the patient to perform acts of daily living, including possible needs of the patient to be continuously assessed by third parties. The invalidity status may in fact influence decisions about how to administer treatments.\r\nProfiles to express disabilities and functional assessments will be specified by future versions of this guide.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr",
              "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionFunctionalStatus.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeDetails.section:sectionFunctionalStatus.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx",
        "path" : "Composition.section",
        "sliceName" : "sectionPatientHx",
        "short" : "Patient History Section",
        "definition" : "This Section describes all aspects of the medical history of the patient even if not pertinent to the current procedure, and may include chief complaint, past medical history, social history, family history, surgical or procedure history, medication history, and other history information. The history may be limited to information pertinent to the current procedure or may be more comprehensive. The history may be reported as a collection of random clinical statements or it may be reported categorically. Categorical report formats may be divided into multiple subsections including Past Medical History, Social History.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHx.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "35090-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Patient History",
        "definition" : "History reported by the patient or caregiver",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHx.section.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHx.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionInfectiousContacts",
        "short" : "Infectious contacts",
        "definition" : "Infectious contacts of the patient",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hdr/CodeSystem/temporarySystem-hdr-cz",
              "code" : "infection-contact"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Exposure to an infectious agent.",
        "definition" : "Information about a suspected infectious agent or agents the person was exposed to.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-infectious-contact-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTravelHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionTravelHx",
        "short" : "Travel History Section",
        "definition" : "This Section describes the travel history relevant for the Patient Summary, e.g.recent travel in a region of high prevalence of a specific infectious disease like Malaria",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTravelHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10182-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTravelHx.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTravelHx.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSocialHistory",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionSocialHistory",
        "short" : "Social History Section",
        "definition" : "The social history section contains a description of the person Health related lifestyle factors or lifestyle observations.   E.g. smoke habits; alcohol consumption; diets, risky habits.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSocialHistory.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29762-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSocialHistory.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSocialHistory.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSocialHistory.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionPastIllnessHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionPastIllnessHx",
        "short" : "HDR History of Past Illness Section",
        "definition" : "The History of Past Illness section contains a narrative description and coded entries of the conditions the patient suffered in the past",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionPastIllnessHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11348-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionPastIllnessHx.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Conditions the patient suffered in the past.",
        "definition" : "It contains a description of the conditions the patient suffered in the past.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionProceduresHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionProceduresHx",
        "short" : "History of Procedures Section",
        "definition" : "The History of Procedures Section contains a description of the patient past procedures that are pertinent to the scope of this document.\r\nProcedures may refer for example to:\r\n1. Invasive Diagnostic procedure:e.g. Cardiac catheterization; (the results of these procedure are documented in the results section)\r\n2. Therapeutic procedure: e.g. dialysis;\r\n3. Surgical procedure: e.g. appendectomy",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionProceduresHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47519-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionProceduresHx.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Patient past procedures pertinent to the scope of this document.",
        "definition" : "It lists the patient past procedures that are pertinent to the scope of this document.\r\nProcedures may refer for example to:\r\n1. Invasive Diagnostic procedure:e.g. Cardiac catheterization; (the results of these procedure are documented in the results section)\r\n2. Therapeutic procedure: e.g. dialysis;\r\n3. Surgical procedure: e.g. appendectomy. This entry shall be used to document that no information about past procedures is available, or that no relevant past procedures are known.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionProceduresHx.entry:procedure",
        "path" : "Composition.section.section.entry",
        "sliceName" : "procedure",
        "short" : "Past Procedure entry",
        "definition" : "Past Procedure entry",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionProceduresHx.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionProceduresHx.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionImmunizations",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionImmunizations",
        "short" : "Immunizations Section",
        "definition" : "The Immunizations Section defines a patient's current immunization status and pertinent immunization history.\r\nThe primary use case for the Immunization Section is to enable communication of a patient's immunization status.\r\nThe section includes current immunization status, and may contain the entire immunization history that is relevant to the period of time being summarized.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionImmunizations.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11369-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionImmunizations.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Patient's immunization status and pertinent history.",
        "definition" : "It defines the patient's current immunization status and pertinent immunization history.\r\nThe primary use case for the Immunization Section is to enable communication of a patient's immunization status.\r\n It may contain the entire immunization history that is relevant to the period of time being summarized. This entry shall be used to document that no information about immunizations is available, or that no immunizations are known.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr",
              "http://hl7.eu/fhir/hdr/StructureDefinition/immunizationRecommendation-eu-hdr",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionImmunizations.entry:immunization",
        "path" : "Composition.section.section.entry",
        "sliceName" : "immunization",
        "short" : "Immunization entry",
        "definition" : "Immunization entry",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionImmunizations.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionImmunizations.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionFamilyHistory",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionFamilyHistory",
        "short" : "Family History Section",
        "definition" : "This section contains data defining the patient’s genetic relatives in terms of possible or relevant health risk factors that have a potential impact on the patient’s healthcare risk profile.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionFamilyHistory.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10157-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionFamilyHistory.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Family History",
        "definition" : "Family History",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-familyMemberHistory-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionFamilyHistory.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionFamilyHistory.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSubstanceUse",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionSubstanceUse",
        "short" : "Use of Substances Section",
        "definition" : "The Use of Substances Section contains a description of the use abuse of substances E.g. tobacco; alcohol; drugs",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSubstanceUse.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hdr/CodeSystem/temporarySystem-hdr-cz",
              "code" : "substance-use"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSubstanceUse.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSubstanceUse.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionSubstanceUse.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionAlcoholUse",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionAlcoholUse",
        "short" : "Alcohol use Section",
        "definition" : "The Alcohol use Section contains a description of the use abuse of alcohol",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionAlcoholUse.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11331-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionAlcoholUse.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionAlcoholUse.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionAlcoholUse.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTobaccoUse",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionTobaccoUse",
        "short" : "Tobacco use Section",
        "definition" : "The Tobacco use Section contains a description of the use abuse of tobacco",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTobaccoUse.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11367-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTobaccoUse.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTobaccoUse.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionTobaccoUse.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionDrugUse",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionDrugUse",
        "short" : "Drug use Section",
        "definition" : "The Drug use Section contains a description of the use abuse of drugs",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionDrugUse.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11343-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionDrugUse.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionDrugUse.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionDrugUse.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionHistoryMedicalDevices",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "sectionHistoryMedicalDevices",
        "short" : "History of Medical devices and implants",
        "definition" : "The medical devices section contains narrative text and coded entries describing the patient history of medical device use.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionHistoryMedicalDevices.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "46264-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionHistoryMedicalDevices.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionHistoryMedicalDevices.section",
        "path" : "Composition.section.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.section:sectionHistoryMedicalDevices.section.section",
        "path" : "Composition.section.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionProblemList",
        "path" : "Composition.section",
        "sliceName" : "sectionProblemList",
        "short" : "Problem List Section",
        "definition" : "The IPS derived problem section lists and describes clinical problems or conditions currently being monitored for the patient.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionProblemList.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionProblemList.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11450-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionProblemList.entry",
        "path" : "Composition.section.entry",
        "short" : "Conditions the patient suffered in the past.",
        "definition" : "It contains a description of the conditions the patient suffered in the past.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/hdr/StructureDefinition/condition-eu-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProblemList.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProblemList.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionCareTeam",
        "path" : "Composition.section",
        "sliceName" : "sectionCareTeam",
        "short" : "Care Team Section",
        "definition" : "// SHORT\n      The Care Team Section is used to share historical and current Care Team information.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionCareTeam.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionCareTeam.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85847-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionCareTeam.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Care Teams",
        "definition" : "Care Teams"
      },
      {
        "id" : "Composition.section:sectionCareTeam.entry:cteam",
        "path" : "Composition.section.entry",
        "sliceName" : "cteam",
        "short" : "Care Team",
        "definition" : "Care Team",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/CareTeam"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionCareTeam.section",
        "path" : "Composition.section.section",
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionCareTeam.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPlanOfCare",
        "path" : "Composition.section",
        "sliceName" : "sectionPlanOfCare",
        "short" : "Plan of Care Section",
        "definition" : "The plan of care section contains a narrative description of the expectations for care including proposals, goals, and order requests for monitoring, tracking, or improving the condition of the patient.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18776-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionDischargeMedications",
        "path" : "Composition.section",
        "sliceName" : "sectionDischargeMedications",
        "short" : "Hospital discharge medications",
        "definition" : "Hospital discharge medications defines the medications that the patient is intended to take, or stop, after discharge",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDischargeMedications.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionDischargeMedications.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "75311-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDischargeMedications.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeMedications.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeMedications.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionDischargeInstructions",
        "path" : "Composition.section",
        "sliceName" : "sectionDischargeInstructions",
        "short" : "Hospital Discharge instructions",
        "definition" : "Hospital Discharge instructions",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionDischargeInstructions.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionDischargeInstructions.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8653-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionDischargeInstructions.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionDischargeInstructions.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives",
        "path" : "Composition.section",
        "sliceName" : "sectionAdvanceDirectives",
        "short" : "Advance Directives Section",
        "definition" : "The advance directives section contains a narrative description of patient's advance directive.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "42348-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAttachments",
        "path" : "Composition.section",
        "sliceName" : "sectionAttachments",
        "short" : "Attachments",
        "definition" : "This section lists documents and attachments associated to this report",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAttachments.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAttachments.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "77599-9"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAttachments.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/Binary"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAttachments.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAttachments.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPayers",
        "path" : "Composition.section",
        "sliceName" : "sectionPayers",
        "short" : "Health insurance and payment information.",
        "definition" : "This section includes heath insurance and payment information.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPayers.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPayers.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48768-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPayers.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPayers.section",
        "path" : "Composition.section.section",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPayers.section.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      }
    ]
  }
}

```
