# A.2.7.1 - Objective findings - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.7.1 - Objective findings**

## Logical Model: A.2.7.1 - Objective findings 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/ObjectiveFindingsCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnObjectiveFindingsHdrEhnCz |

 
Hospital Discharge Report - Objective Findings- A.2.7.1 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/ObjectiveFindingsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ObjectiveFindingsCz.csv), [Excel](StructureDefinition-ObjectiveFindingsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ObjectiveFindingsCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/ObjectiveFindingsCz",
  "version" : "0.1.0",
  "name" : "LogEnObjectiveFindingsHdrEhnCz",
  "title" : "A.2.7.1 - Objective findings",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Objective Findings- A.2.7.1 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/ObjectiveFindingsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ObjectiveFindingsCz",
        "path" : "ObjectiveFindingsCz",
        "short" : "A.2.7.1 - Objective findings",
        "definition" : "Hospital Discharge Report - Objective Findings- A.2.7.1 eHN"
      },
      {
        "id" : "ObjectiveFindingsCz.date",
        "path" : "ObjectiveFindingsCz.date",
        "short" : "A.2.8.1.1 - Date",
        "definition" : "Date and time of the examination at or before discharge",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.anthropometricObservations",
        "path" : "ObjectiveFindingsCz.anthropometricObservations",
        "short" : "A.2.8.1.3 - Anthropometric observations",
        "definition" : "Observation of Body weight and height of the patient, BMI, circumference of head, waist, hip, limbs and skin fold thickness.Result of the observation includes text, numeric and coded results of the measurement including measurement units. Multiple observations could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.anthropometricObservations.description",
        "path" : "ObjectiveFindingsCz.anthropometricObservations.description",
        "short" : "A.2.8.1.3.1 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.anthropometricObservations.details",
        "path" : "ObjectiveFindingsCz.anthropometricObservations.details",
        "short" : "A.2.8.1.3.2 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.anthropometricObservations.result",
        "path" : "ObjectiveFindingsCz.anthropometricObservations.result",
        "short" : "A.2.8.1.3.3 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.vitalSigns",
        "path" : "ObjectiveFindingsCz.vitalSigns",
        "short" : "A.2.8.1.4 - Vital signs",
        "definition" : "Observation of Vital signs:\n• Recommended: systolic and diastolic blood pressure including site of measurement, pulse rate, respiratory rate\n• Optional: 02 saturation, temperature, pain (scale), ...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.vitalSigns.description",
        "path" : "ObjectiveFindingsCz.vitalSigns.description",
        "short" : "A.2.8.1.4.1 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.vitalSigns.details",
        "path" : "ObjectiveFindingsCz.vitalSigns.details",
        "short" : "A.2.8.1.4.2 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.vitalSigns.result",
        "path" : "ObjectiveFindingsCz.vitalSigns.result",
        "short" : "A.2.8.1.4.3 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.physicalExamination",
        "path" : "ObjectiveFindingsCz.physicalExamination",
        "short" : "A.2.8.1.5 - Physical examination",
        "definition" : "Physical examination (at discharge) is the process of evaluating objective anatomical findings. Physical examination can be performed through observation, palpation, percussion, and auscultation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ObjectiveFindingsCz.physicalExamination.description",
        "path" : "ObjectiveFindingsCz.physicalExamination.description",
        "short" : "A.2.8.1.5.1 - Observation Note",
        "definition" : "A narrative description of the observation. It should be structured by the organ system (e.g. head, neck, body, arms, ...)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
