# A.2.8.2 - Medication summary - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.8.2 - Medication summary**

## Logical Model: A.2.8.2 - Medication summary 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/MedicationSummaryCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnMedicationSummaryHdrEhnCz |

 
Hospital Discharge Report - Medication Summary after discharge - A.2.8.2 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/MedicationSummaryCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationSummaryCz.csv), [Excel](StructureDefinition-MedicationSummaryCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationSummaryCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/MedicationSummaryCz",
  "version" : "0.1.0",
  "name" : "LogEnMedicationSummaryHdrEhnCz",
  "title" : "A.2.8.2 - Medication summary",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Medication Summary after discharge - A.2.8.2 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/MedicationSummaryCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationSummaryCz",
        "path" : "MedicationSummaryCz",
        "short" : "A.2.8.2 - Medication summary",
        "definition" : "Hospital Discharge Report - Medication Summary after discharge - A.2.8.2 eHN"
      },
      {
        "id" : "MedicationSummaryCz.reason",
        "path" : "MedicationSummaryCz.reason",
        "short" : "A.2.9.2.1 - Medication reason",
        "definition" : "The reason why the medication is or was prescribed or used. It provides a link to the Past or current health condition(s) or problem(s) that the patient has had or has and for which this medication was prescribed.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.changeReason",
        "path" : "MedicationSummaryCz.changeReason",
        "short" : "A.2.9.2.2 - Reason for change",
        "definition" : "Reason for change of medication",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.productCode",
        "path" : "MedicationSummaryCz.productCode",
        "short" : "A.2.9.2.3 - Code",
        "definition" : "Product code.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.productName",
        "path" : "MedicationSummaryCz.productName",
        "short" : "A.2.9.2.4 - Brand name",
        "definition" : "Brand name if biological medicinal product or when justified by the health professional (ref. Commission Directive 2012/52/EU)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.activeIngredient",
        "path" : "MedicationSummaryCz.activeIngredient",
        "short" : "A.2.9.2.5 - Active ingredient list",
        "definition" : "Substance that alone or in combination with one or more other ingredients produces the intended activity of a medicinal product. Example: \\'paracetamol\\'",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.strength",
        "path" : "MedicationSummaryCz.strength",
        "short" : "A.2.9.2.6 - Strength",
        "definition" : "The content of the active ingredient expressed quantifiably per dosage unit, per unit of volume or per unit of weight, according to the pharmaceutical dose form. Example: 500 mg per tablet",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.doseForm",
        "path" : "MedicationSummaryCz.doseForm",
        "short" : "A.2.9.2.7 - Pharmaceutical dose form",
        "definition" : "The form in which a pharmaceutical product is presented in the medicinal product package (e.g. tablet, syrup)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.dosageRegimen",
        "path" : "MedicationSummaryCz.dosageRegimen",
        "short" : "A.2.9.2.8 - Dosage Regimen",
        "definition" : "Number of units per intake and frequency of intake over a specified duration of time.\nExample: 1 tablet every 24h, for 10 days",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.route",
        "path" : "MedicationSummaryCz.route",
        "short" : "A.2.9.2.9 - Route of administration",
        "definition" : "Path by which the pharmaceutical product is taken into or makes contact with the body.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.period",
        "path" : "MedicationSummaryCz.period",
        "short" : "A.2.9.2.10 - Period of treatment",
        "definition" : "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.daysSupplied",
        "path" : "MedicationSummaryCz.daysSupplied",
        "short" : "A.2.9.2.11 - Days supplied",
        "definition" : "Number of days for which the patient was provided with the drug. Supply is intended to either hand over the medicine or write out a prescription. A 0 value indicates that the patient has not been provided with the drug (e.g. if the patient has a sufficient supply of the drug)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
