# A.3 - Vizuální podoba dokumentu - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3 - Vizuální podoba dokumentu**

## Logical Model: A.3 - Vizuální podoba dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogPresentedFormCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzPresentedFormCz |

 
Nemocniční propouštěcí zpráva - čitelná lidským okem, je požadován PDF formát. Obsahuje informace o průběhu hospitalizace v rozsahu vydané zprávy. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogPresentedFormCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogPresentedFormCz.csv), [Excel](StructureDefinition-LogPresentedFormCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogPresentedFormCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPresentedFormCz",
  "version" : "0.1.0",
  "name" : "LogCzPresentedFormCz",
  "title" : "A.3 - Vizuální podoba dokumentu",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - čitelná lidským okem, je požadován PDF formát. Obsahuje informace o průběhu hospitalizace v rozsahu vydané zprávy.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPresentedFormCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogPresentedFormCz",
        "path" : "LogPresentedFormCz",
        "short" : "A.3 - Vizuální podoba dokumentu",
        "definition" : "Nemocniční propouštěcí zpráva - čitelná lidským okem, je požadován PDF formát. Obsahuje informace o průběhu hospitalizace v rozsahu vydané zprávy."
      },
      {
        "id" : "LogPresentedFormCz.zobrazitelnaFormadokumentu",
        "path" : "LogPresentedFormCz.zobrazitelnaFormadokumentu",
        "short" : "A.3 - Vizuální podoba dokumentu",
        "definition" : "Vizuální podoba dokumentu",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.typObsahu",
        "path" : "LogPresentedFormCz.typObsahu",
        "short" : "A.3.1 Typ obsahu",
        "definition" : "Typ obsahu - je  požadován MIME typ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.jazyk",
        "path" : "LogPresentedFormCz.jazyk",
        "short" : "A.3.2 Jazyk obsahu",
        "definition" : "Jazyk obsahu - je požadována hodnata z HL7 valueset Languages",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.data",
        "path" : "LogPresentedFormCz.data",
        "short" : "A.3.3 Data obsahu",
        "definition" : "Data v base64",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.url",
        "path" : "LogPresentedFormCz.url",
        "short" : "A.3.4 URL obsahu",
        "definition" : "Uri kde lze data nalézt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.nazev",
        "path" : "LogPresentedFormCz.nazev",
        "short" : "A.3.5 Název obsahu",
        "definition" : "Titulek, který bude zobrazen před daty",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.vytvoreni",
        "path" : "LogPresentedFormCz.vytvoreni",
        "short" : "A.3.6 Datum vytvoření",
        "definition" : "Datum, kdy byl obsah poprvé vytvořen",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
