# A.2.9.1 Plán péče - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.9.1 Plán péče**

## Logical Model: A.2.9.1 Plán péče 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogPlanOfCareCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:PLogCzlanOfCareHdrCz |

 
Nemocniční propouštěcí zpráva - Plán péče po propuštění. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogPlanOfCareCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogPlanOfCareCz.csv), [Excel](StructureDefinition-LogPlanOfCareCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogPlanOfCareCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPlanOfCareCz",
  "version" : "0.1.0",
  "name" : "PLogCzlanOfCareHdrCz",
  "title" : "A.2.9.1 Plán péče",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Plán péče po propuštění.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPlanOfCareCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogPlanOfCareCz",
        "path" : "LogPlanOfCareCz",
        "short" : "A.2.9.1 Plán péče",
        "definition" : "Nemocniční propouštěcí zpráva - Plán péče po propuštění."
      },
      {
        "id" : "LogPlanOfCareCz.nazev",
        "path" : "LogPlanOfCareCz.nazev",
        "short" : "A.2.9.1.1 Název",
        "definition" : "...Název plánu péče, např. 'Plán péče po endoprotéze kyčelního kloubu'...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.resi",
        "path" : "LogPlanOfCareCz.resi",
        "short" : "A.2.9.1.2 Řeší",
        "definition" : "...Onemocnění či stavy, na které se plán vztahuje. Vybere lékař ze seznamu zdravotních problémů uvedených v diagnostickém souhrnu...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.popis",
        "path" : "LogPlanOfCareCz.popis",
        "short" : "A.2.9.1.3 Popis doporučení",
        "definition" : "...Popis typu a povahy plánu péče...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.obdobi",
        "path" : "LogPlanOfCareCz.obdobi",
        "short" : "A.2.9.1.4 Období",
        "definition" : "...Období, ve kterém by měl být plán péče realizován...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.podrobnosti",
        "path" : "LogPlanOfCareCz.podrobnosti",
        "short" : "A.2.9.1.5 Další podrobnosti plánu",
        "definition" : "...Další strukturované informace popisující cíle plánu, složení terapeutického týmu apod...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.aktivity",
        "path" : "LogPlanOfCareCz.aktivity",
        "short" : "A.2.9.1.6 Aktivity",
        "definition" : "...Jednotlivé aktivity plánu...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.aktivity.typ",
        "path" : "LogPlanOfCareCz.aktivity.typ",
        "short" : "A.2.9.1.6.1 Typ aktivity",
        "definition" : "...Popis aktivity léčebného plánu. Např. doporučená medikace, požadovaná vyšetření, požadavky na komunikaci, dietní doporučení, režimová opatření, plánované kontroly apod...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.aktivity.popis",
        "path" : "LogPlanOfCareCz.aktivity.popis",
        "short" : "A.2.9.1.6.2 Popis aktivity",
        "definition" : "...Detailní popis plánované aktivity volným textem...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPlanOfCareCz.aktivity.atributy",
        "path" : "LogPlanOfCareCz.aktivity.atributy",
        "short" : "A.2.9.1.6.3 Specifické atributy",
        "definition" : "...Specifické atributy pro jednotlivé typy aktivit...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
