# A.2.9.2 Souhrn medikace - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.9.2 Souhrn medikace**

## Logical Model: A.2.9.2 Souhrn medikace 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogMedicationSummaryCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzMedicationSummaryHdrCz |

 
Nemocniční propouštěcí zpráva - Souhrnná informace o medikaci doporučené na období po propuštění, včetně medikace změněné, nově zahájené nebo ukončené. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogMedicationSummaryCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogMedicationSummaryCz.csv), [Excel](StructureDefinition-LogMedicationSummaryCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogMedicationSummaryCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogMedicationSummaryCz",
  "version" : "0.1.0",
  "name" : "LogCzMedicationSummaryHdrCz",
  "title" : "A.2.9.2 Souhrn medikace",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Souhrnná informace o medikaci doporučené na období po propuštění, včetně medikace změněné, nově zahájené nebo ukončené.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogMedicationSummaryCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogMedicationSummaryCz",
        "path" : "LogMedicationSummaryCz",
        "short" : "A.2.9.2 Souhrn medikace",
        "definition" : "Nemocniční propouštěcí zpráva - Souhrnná informace o medikaci doporučené na období po propuštění, včetně medikace změněné, nově zahájené nebo ukončené."
      },
      {
        "id" : "LogMedicationSummaryCz.stav",
        "path" : "LogMedicationSummaryCz.stav",
        "short" : "A.2.9.2.1 Stav",
        "definition" : "Stav identifikuje změny v medikaci v průběhu hospitalizace. Položka je důležitá pro rozlišení medikace ukončené, změněné či nově podávané v průběhu hospitalizace.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.indikace",
        "path" : "LogMedicationSummaryCz.indikace",
        "short" : "A.2.9.2.2 Indikace",
        "definition" : "Důvod medikace. Důvod může být popsán textem případně odkazem na zdravotní důvod (zdravotní problém v seznamu problémů).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.duvodZmeny",
        "path" : "LogMedicationSummaryCz.duvodZmeny",
        "short" : "A.2.9.2.3 Důvod změny medikace",
        "definition" : "Důvod změny medikace vyjádřený textem případně kódem (např. nevhodné/nedostatečné dávkování, interakce léků a pod.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.suklKode",
        "path" : "LogMedicationSummaryCz.suklKode",
        "short" : "A.2.9.2.4 Kód SUKL",
        "definition" : "Kód léčiva dle databáze SÚKL.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.nazevLeku",
        "path" : "LogMedicationSummaryCz.nazevLeku",
        "short" : "A.2.9.2.5 Název léčivého přípravku",
        "definition" : "Registrovaný název léčiva dle databáze léčivých přípravků, nebo IPS Absent and Unknown.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.aktivniLatky",
        "path" : "LogMedicationSummaryCz.aktivniLatky",
        "short" : "A.2.9.2.6 Aktivní látky",
        "definition" : "Seznam aktivních látek v léčivu odvozený od záznamu HVLP nebo IVLP přípravku v databázi SUKL (DLP). Aktivní látky jsou uváděny názvem a případně také kódem ATC či IDMP dle registru substancí SRS.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.sila",
        "path" : "LogMedicationSummaryCz.sila",
        "short" : "A.2.9.2.7 Síla",
        "definition" : "Síla aktivní léčivé látky obsažené v léčivém přípravku. Síla se vyjadřuje ve vztahu k jednotce podání. Např. 500mg v tabletě.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.forma",
        "path" : "LogMedicationSummaryCz.forma",
        "short" : "A.2.9.2.8 Forma léčiva",
        "definition" : "Léková forma obsažená v balení vyjádřená kódem. Např. sirup, tableta apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.davkovani",
        "path" : "LogMedicationSummaryCz.davkovani",
        "short" : "A.2.9.2.9 Dávkování",
        "definition" : "Frekvence a počet jednotek podání volným textem nebo formalizovaně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.cestaPodani",
        "path" : "LogMedicationSummaryCz.cestaPodani",
        "short" : "A.2.9.2.10 Cesta podání",
        "definition" : "Cesta podání.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.obdobiPodani",
        "path" : "LogMedicationSummaryCz.obdobiPodani",
        "short" : "A.2.9.2.11 Období podávání",
        "definition" : "Časový interval kdy pacientovi byla, případně nebyla medikace podávána.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "LogMedicationSummaryCz.delkaVybaveni",
        "path" : "LogMedicationSummaryCz.delkaVybaveni",
        "short" : "A.2.9.2.12 Délka vybavení",
        "definition" : "Počet dnů na který byl pacient vybaven léčivem. Pokud pacient nebyl vybaven, lékař zaznamená hodnotu 0.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
