# A - Propouštěcí zpráva - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Propouštěcí zpráva**

## Logical Model: A - Propouštěcí zpráva 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogHospitalDischargeReportCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzHospitalDischargeReportCz |

 
Nemocniční propouštěcí zpráva 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogHospitalDischargeReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogHospitalDischargeReportCz.csv), [Excel](StructureDefinition-LogHospitalDischargeReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogHospitalDischargeReportCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHospitalDischargeReportCz",
  "version" : "0.1.0",
  "name" : "LogCzHospitalDischargeReportCz",
  "title" : "A - Propouštěcí zpráva",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHospitalDischargeReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogHospitalDischargeReportCz",
        "path" : "LogHospitalDischargeReportCz",
        "short" : "A - Propouštěcí zpráva",
        "definition" : "Nemocniční propouštěcí zpráva"
      },
      {
        "id" : "LogHospitalDischargeReportCz.hlavicka",
        "path" : "LogHospitalDischargeReportCz.hlavicka",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Hlavička propouštěcí zprávy – podle české specifikace",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHeaderHdrCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo",
        "path" : "LogHospitalDischargeReportCz.telo",
        "short" : "A.2 - Tělo propouštěcí zprávy",
        "definition" : "Hlavní klinické části propouštěcí zprávy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.driveVyslovenaPrani",
        "path" : "LogHospitalDischargeReportCz.telo.driveVyslovenaPrani",
        "short" : "A.2.1 - Dříve vyslovená přání",
        "definition" : "Dříve vyslovená přání pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAdvanceDirectivesCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.alerts",
        "path" : "LogHospitalDischargeReportCz.telo.alerts",
        "short" : "A.2.2 - Urgentní informace",
        "definition" : "Závažné alergie, interakce nebo jiná rizika.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAlertsCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.udajeOHospitalizaci",
        "path" : "LogHospitalDischargeReportCz.telo.udajeOHospitalizaci",
        "short" : "A.2.3 - Údaje o hospitalizaci",
        "definition" : "Záznam o samotné hospitalizaci a jejím průběhu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogInPatientEncounterCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.duvodPrijeti",
        "path" : "LogHospitalDischargeReportCz.telo.duvodPrijeti",
        "short" : "A.2.4 - Důvod přijetí",
        "definition" : "Vyhodnocení zdravotního stavu při příjmu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAdmissionEvaluationCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.anamneza",
        "path" : "LogHospitalDischargeReportCz.telo.anamneza",
        "short" : "A.2.6 - Anamnéza pacienta",
        "definition" : "Stručná anamnéza, včetně původu informací.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPatientHistoryCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.prubehHospitalizace",
        "path" : "LogHospitalDischargeReportCz.telo.prubehHospitalizace",
        "short" : "A.2.7 - Průběh hospitalizace",
        "definition" : "Popis průběhu hospitalizace pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHospitalStayCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni",
        "path" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni",
        "short" : "A.2.8 - Stav při propuštění",
        "definition" : "Strukturované nebo narativní informace o ukončení hospitalizace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogDischargeDetailsCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni.objektivniNalez",
        "path" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni.objektivniNalez",
        "short" : "A.2.8.1 - Objektivní nález",
        "definition" : "Objektivní klinické nálezy při propuštění.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogCzObjectiveFindingsCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni.funkcniStav",
        "path" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni.funkcniStav",
        "short" : "A.2.8.2 - Funkční stav při propuštění",
        "definition" : "Zhodnocení schopnosti pacienta vykonávat denní aktivity.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogFunctionalStatusCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni.poznamka",
        "path" : "LogHospitalDischargeReportCz.telo.stavPriPropusteni.poznamka",
        "short" : "A.2.8.3 - Poznámka k propuštění",
        "definition" : "Shrnutí propuštění ve formě volného textu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.doporuceni",
        "path" : "LogHospitalDischargeReportCz.telo.doporuceni",
        "short" : "A.2.9 - Doporučení po propuštění",
        "definition" : "Doporučení, péče a léčba po ukončení hospitalizace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.doporuceni.planPece",
        "path" : "LogHospitalDischargeReportCz.telo.doporuceni.planPece",
        "short" : "A.2.9.1 - Plán péče",
        "definition" : "Plánované kroky péče po propuštění.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPlanOfCareCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.telo.doporuceni.souhrnaMedikace",
        "path" : "LogHospitalDischargeReportCz.telo.doporuceni.souhrnaMedikace",
        "short" : "A.2.9.2 - Souhrná medikace",
        "definition" : "Shrnutí předepsané i ukončené medikace.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogMedicationSummaryCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.zobrazitelnaForma",
        "path" : "LogHospitalDischargeReportCz.zobrazitelnaForma",
        "short" : "A.3 - Zobrazitelná forma dokumentu",
        "definition" : "Zobrazená verze dokumentu, doporučeno PDF.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPresentedFormCz"
          }
        ]
      },
      {
        "id" : "LogHospitalDischargeReportCz.prilohy",
        "path" : "LogHospitalDischargeReportCz.prilohy",
        "short" : "A.4 - Přílohy",
        "definition" : "Přiložené obrázky, dokumenty nebo jiná média.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
