# A.2.8.2 - Funkční stav při propuštění - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.8.2 - Funkční stav při propuštění**

## Logical Model: A.2.8.2 - Funkční stav při propuštění 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogFunctionalStatusCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzFunctionalStatusHdrCz |

 
Nemocniční propouštěcí zpráva - Hodnocení funkčního stavu pacienta při propuštění. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogFunctionalStatusCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogFunctionalStatusCz.csv), [Excel](StructureDefinition-LogFunctionalStatusCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogFunctionalStatusCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogFunctionalStatusCz",
  "version" : "0.1.0",
  "name" : "LogCzFunctionalStatusHdrCz",
  "title" : "A.2.8.2 - Funkční stav při propuštění",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Hodnocení funkčního stavu pacienta při propuštění.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogFunctionalStatusCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogFunctionalStatusCz",
        "path" : "LogFunctionalStatusCz",
        "short" : "A.2.8.2 - Funkční stav při propuštění",
        "definition" : "Nemocniční propouštěcí zpráva - Hodnocení funkčního stavu pacienta při propuštění."
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav",
        "path" : "LogFunctionalStatusCz.funkcniStav",
        "short" : "A.2.8.2 Funkční stav při propuštění",
        "definition" : "Funkční stav lze hodnotit několika různými způsoby, obvykle se zaměřením na schopnosti osoby vykonávat základní aktivity každodenního života (ADL), které zahrnují základní sebeobsluhu, jako je koupání, krmení a toaleta a instrumentální aktivity každodenního života (IADL), které zahrnují činnosti jako vaření, nakupování a řízení vlastních záležitostí.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.datum",
        "path" : "LogFunctionalStatusCz.funkcniStav.datum",
        "short" : "A.2.8.2.1 Datum a čas",
        "definition" : "Datum a čas hodnocení funkčního stavu pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.performer",
        "path" : "LogFunctionalStatusCz.funkcniStav.performer",
        "short" : "A.2.8.2.2 Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.popis",
        "path" : "LogFunctionalStatusCz.funkcniStav.popis",
        "short" : "A.2.8.2.3 Popis",
        "definition" : "Textový popis funkčního stavu pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni",
        "path" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni",
        "short" : "A.2.8.2.4 Hodnocení formalizované",
        "definition" : "Formalizované hodnocení funkčního stavu pacienta dle jednotlivých hodnotících kategorií (např. MKF).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.datumVzniku",
        "path" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.datumVzniku",
        "short" : "A.2.8.2.4.1 Datum vzniku",
        "definition" : "Datum vzniku funkčního omezení.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.vysledekTextem",
        "path" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.vysledekTextem",
        "short" : "A.2.8.2.4.2 Výsledek vyšetření textem",
        "definition" : "Výsledek vyšetření volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.popisVysetreni",
        "path" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.popisVysetreni",
        "short" : "A.2.8.2.4.3 Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu. Jako výchozí systém pro hodnocení funkčního stavu byl zvolen mezinárodní klasifikační systém MKF. Další typy hodnotících škál mohou být doplněny v budoucích verzích standardu na základě potřeby a konsenzu odborné veřejnosti.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.vysledek",
        "path" : "LogFunctionalStatusCz.funkcniStav.formalizovaneHodnoceni.vysledek",
        "short" : "A.2.8.2.4.4 Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek hodnocení funkčního stavu v dané kategorii hodnocení.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
