# A.2.1 - Dříve vyslovená přání (cz) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Dříve vyslovená přání (cz)**

## Logical Model: A.2.1 - Dříve vyslovená přání (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogAdvanceDirectivesCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzAdvanceDirectivesEhnCz |

 
Nemocniční propouštěcí zpráva - Dříve vyslovená přání 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogAdvanceDirectivesCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogAdvanceDirectivesCz.csv), [Excel](StructureDefinition-LogAdvanceDirectivesCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogAdvanceDirectivesCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAdvanceDirectivesCz",
  "version" : "0.1.0",
  "name" : "LogCzAdvanceDirectivesEhnCz",
  "title" : "A.2.1 - Dříve vyslovená přání (cz)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Dříve vyslovená přání ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAdvanceDirectivesCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogAdvanceDirectivesCz",
        "path" : "LogAdvanceDirectivesCz",
        "short" : "A.2.1 - Dříve vyslovená přání (cz)",
        "definition" : "Nemocniční propouštěcí zpráva - Dříve vyslovená přání "
      },
      {
        "id" : "LogAdvanceDirectivesCz.driveVyslovenaPrani",
        "path" : "LogAdvanceDirectivesCz.driveVyslovenaPrani",
        "short" : "A.2.1.1 - Dříve vyslovená přání",
        "definition" : "Záznam dříve vysloveného přání. Pouze záznamy, které jsou vyjádřeny během aktuálního hospitalizačního pobytu. Může být uvedeno více záznamů dříve vyslovených přání.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.datum",
        "path" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.datum",
        "short" : "A.2.1.1.1 - Datum a čas",
        "definition" : "Datum a čas vyjádřeného přání pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.typ",
        "path" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.typ",
        "short" : "A.2.1.1.2 - Typ přání",
        "definition" : "Typ přání kódem nebo textem. Např. Příkaz k resuscitaci, prohlášení o darování orgánů, plná moc apod.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.komentar",
        "path" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.komentar",
        "short" : "A.2.1.1.3 - Komentář",
        "definition" : "Komentář k projevenému přání pacienta",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.stav",
        "path" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.stav",
        "short" : "A.2.1.1.4 - Dotčený stav",
        "definition" : "Stav na který se přání vztahuje. Přání může být vztaženo pouze k určitému zdravotnímu problému či množině problémů.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.dokument",
        "path" : "LogAdvanceDirectivesCz.driveVyslovenaPrani.dokument",
        "short" : "A.2.1.1.5 - Dokument",
        "definition" : "Fotokopie dokumentu či elektronický dokument s projeveným přáním pacienta mající náležitosti požadované zákonem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
