# A.2.7 - Discharge details (eHN) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.7 - Discharge details (eHN)**

## Logical Model: A.2.7 - Discharge details (eHN) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/DischargeDetailsCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnDischargeDetailsEhnCz |

 
Hospital Discharge Report - Discharge details - A.2.7 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/DischargeDetailsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DischargeDetailsCz.csv), [Excel](StructureDefinition-DischargeDetailsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DischargeDetailsCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/DischargeDetailsCz",
  "version" : "0.1.0",
  "name" : "LogEnDischargeDetailsEhnCz",
  "title" : "A.2.7 - Discharge details (eHN)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Discharge details - A.2.7 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/DischargeDetailsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "DischargeDetailsCz",
        "path" : "DischargeDetailsCz",
        "short" : "A.2.7 - Discharge details (eHN)",
        "definition" : "Hospital Discharge Report - Discharge details - A.2.7 eHN"
      }
    ]
  }
}

```
