# CZ-Procedure-HDR Example - Pacemaker - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Procedure-HDR Example - Pacemaker**

## Example Procedure: CZ-Procedure-HDR Example - Pacemaker

Procedure: Zavedení kardiostimulátoru

Date: 2024-03-05

Patient: Petr Novák

Reason: Úplná atrioventrikulární blokáda

Outcome: Úspěšný

Device: Kardiostimulátor Medtronic W1DR01



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "Procedure-Insert-Pacemaker2",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "70573000",
        "display" : "Insertion of pacemaker pulse generator"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "performedDateTime" : "2024-03-05",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/sid/icd-10",
          "code" : "I50",
          "display" : "Heart failure"
        }
      ]
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "73829009",
          "display" : "Right atrial structure"
        }
      ]
    }
  ],
  "outcome" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "385669000",
        "display" : "Successful (qualifier value)"
      }
    ]
  },
  "focalDevice" : [
    {
      "action" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "129303008",
            "display" : "Removal - action"
          }
        ]
      },
      "manipulated" : {
        "reference" : "Device/Device-Pacemaker"
      }
    }
  ]
}

```
