# CZ-Procedure-HDR Example - Acute appendicitis - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Procedure-HDR Example - Acute appendicitis**

## Example Procedure: CZ-Procedure-HDR Example - Acute appendicitis

Procedure: Apendektomie

Date: 2023-10-01T10:00:00Z

Reason: Akutní apendicitida

Complication: Peritonitida

Outcome: Částečně úspěšný

Text: Pacient byl přijat s akutní bolestí břicha, horečkou a známkami podráždění pobřišnice. Klinické vyšetření a zobrazovací metody potvrdily diagnózu akutní apendicitidy s generalizovanou peritonitidou (MKN-10: K35.2, K65.0). Byla provedena urgentní laparotomie, při které bylo odhaleno perforované apendix s difuzní hnisavou peritonitidou. Byla provedena apendektomie a následně peritoneální výplach a drenáž. Byla podána pooperační antibiotika. Pacient se momentálně zotavuje pod pečlivým dohledem.



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "CZ-Procedure-HDR-Example-Acute-appendicitis",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "80146002",
        "display" : "Appendectomy"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Mracena2"
  },
  "performedDateTime" : "2023-10-01T10:00:00Z",
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/Practitioner-2"
      }
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/sid/icd-10",
          "code" : "K35.2",
          "display" : "Acute appendicitis with generalized peritonitis"
        }
      ]
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "66754008",
          "display" : "Appendix"
        }
      ]
    }
  ],
  "outcome" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "385670004",
        "display" : "Partially successful (qualifier value)"
      }
    ]
  },
  "complication" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/sid/icd-10",
          "code" : "K65.0",
          "display" : "Acute peritonitis"
        }
      ]
    }
  ]
}

```
