# PractitionerRole1 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **PractitionerRole1**

## Example PractitionerRole: PractitionerRole1

version: 1; Last updated: 2019-07-01 13:30:55+0000

Profile: [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

**identifier**: `http://www.acme.org/practitioners`/23

**active**: true

**period**: 2022-08-01 00:00:00+0000 --> 2022-12-31 00:00:00+0000

**practitioner**: [MUDr. Stanislava Kubšová](Practitioner-Practitioner-2.md)

**organization**: [Ordinace praktického lékaře, MUDr. Stanislava Kubšová](https://build.fhir.org/ig/HL7-cz/cz-core/Organization-Organization-1.html)

**code**: Lékař

**specialty**: Family practice (qualifier value)

> **availableTime****daysOfWeek**: Tuesday, Wednesday**availableStartTime**: 12:30:00**availableEndTime**: 18:30:00

> **availableTime****daysOfWeek**: Thursday, Friday**availableStartTime**: 07:00:00**availableEndTime**: 13:00:00

### NotAvailables

| | | |
| :--- | :--- | :--- |
| - | **Description** | **During** |
| * | Plánovaná dovolená | 2023-08-01 00:00:00+0000 --> 2023-08-20 00:00:00+0000 |

**availabilityExceptions**: Státní svátky



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "practitionerrole1",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2019-07-01T13:30:55.864+00:00",
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
    ]
  },
  "identifier" : [
    {
      "system" : "http://www.acme.org/practitioners",
      "value" : "23"
    }
  ],
  "active" : true,
  "period" : {
    "start" : "2022-08-01T00:00:00.000Z",
    "end" : "2022-12-31T00:00:00.000Z"
  },
  "practitioner" : {
    "reference" : "Practitioner/Practitioner-2",
    "display" : "MUDr. Stanislava Kubšová"
  },
  "organization" : {
    "reference" : "Organization/Organization-1",
    "display" : "Ordinace praktického lékaře, MUDr. Stanislava Kubšová"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/nrzp-povolani",
          "code" : "L00",
          "display" : "Lékař"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "419772000",
          "display" : "Family practice (qualifier value)"
        }
      ]
    }
  ],
  "availableTime" : [
    {
      "daysOfWeek" : ["tue", "wed"],
      "availableStartTime" : "12:30:00",
      "availableEndTime" : "18:30:00"
    },
    {
      "daysOfWeek" : ["thu", "fri"],
      "availableStartTime" : "07:00:00",
      "availableEndTime" : "13:00:00"
    }
  ],
  "notAvailable" : [
    {
      "description" : "Plánovaná dovolená",
      "during" : {
        "start" : "2023-08-01T00:00:00.000Z",
        "end" : "2023-08-20T00:00:00.000Z"
      }
    }
  ],
  "availabilityExceptions" : "Státní svátky"
}

```
