# ExampleSdohSmoking - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ExampleSdohSmoking**

## Example Observation: ExampleSdohSmoking

Profile: [Observation: SDOH (HDR CZ)](StructureDefinition-cz-observation-sdoh-hdr.md)

**status**: Final

**category**: Social History

**code**: Tobacco use and exposure

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2017-04-15 00:00:00+0200 --> 2020-04-15 00:00:00+0200

**performer**: [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md)

**value**: 0.5 {pack}/d

**note**: 

> 

Entered by Všeobecný lékař




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ExampleSdohSmoking",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "229819007",
        "display" : "Tobacco use and exposure"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectivePeriod" : {
    "start" : "2017-04-15T00:00:00+02:00",
    "end" : "2020-04-15T00:00:00+02:00"
  },
  "performer" : [
    {
      "reference" : "Practitioner/Practitioner-2"
    }
  ],
  "valueCodeableConcept" : {
    "text" : "0.5 {pack}/d"
  },
  "note" : [
    {
      "text" : "Entered by Všeobecný lékař"
    }
  ]
}

```
