# Stav při propuštění - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Stav při propuštění**

## Example Observation: Stav při propuštění

**status**: Final

**category**: Exam

**code**: Condition status

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2024-03-29

**performer**: [Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a)

**value**: Patient's condition improved

**interpretation**: Normal

**note**: 

> 

Pacient ve stabilizovaném stavu, bez komplikací.




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "3f85726c-ad2f-441b-89ce-100000000021",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam",
          "display" : "Exam"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "66455-7",
        "display" : "Condition status"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectiveDateTime" : "2024-03-29",
  "performer" : [
    {
      "reference" : "urn:uuid:a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "268910001",
        "display" : "Patient's condition improved"
      }
    ]
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ],
  "note" : [
    {
      "text" : "Pacient ve stabilizovaném stavu, bez komplikací."
    }
  ]
}

```
