# Goal for Hernia Treatment - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Goal for Hernia Treatment**

## Example Goal: Goal for Hernia Treatment

**lifecycleStatus**: Active

**description**: Chirurgické řešení tříselné kýly s úplným zhojením a bez komplikací.

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**start**: 2025-03-10

### Targets

| | | |
| :--- | :--- | :--- |
| - | **Measure** | **Detail[x]** |
| * | Finding of wound healing | Zhojená rána bez komplikací, bez recidivy kýly. |



## Resource Content

```json
{
  "resourceType" : "Goal",
  "id" : "620b1120-cece-44b1-89f5-20413054eb1d",
  "lifecycleStatus" : "active",
  "description" : {
    "text" : "Chirurgické řešení tříselné kýly s úplným zhojením a bez komplikací."
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "startDate" : "2025-03-10",
  "target" : [
    {
      "measure" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "298005009",
            "display" : "Finding of wound healing"
          }
        ]
      },
      "detailString" : "Zhojená rána bez komplikací, bez recidivy kýly."
    }
  ]
}

```
