# CZ-Encounter-HDR Example of encounter with emergency priority - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Encounter-HDR Example of encounter with emergency priority**

## Example Encounter: CZ-Encounter-HDR Example of encounter with emergency priority

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**status**: finished

**class**: [ActCode: IMP](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**priority**: emergency

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

> **participant****type**:Admitter**individual**:[Practitioner MUDr. Karel Volný](Practitioner-Practitioner-Admitter.md)

> **participant****type**:Referrer**individual**:[PractitionerRole Lékař](PractitionerRole-Practitioner-Referrer-detail.md)

**period**: 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100

**reasonReference**: [Condition Unilateral or unspecified inguinal hernia, without obstruction or gangrene](Bundle-DischargeBundle-Novak-Petr-Subsections.md#urn-uuid-35717696-8a99-4f99-a938-ec0ec88a65a2)

### Hospitalizations

| | | |
| :--- | :--- | :--- |
| - | **AdmitSource** | **DischargeDisposition** |
| * | From outpatient department | Home |

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)**period**: 2025-03-01 08:00:00+0100 --> 2025-03-02 08:00:00+0100

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR-JIP](Location-cz-Location-Chrudim-ChirJIP.md)**period**: 2025-03-02 08:00:00+0100 --> 2025-03-04 08:00:00+0100

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)**period**: 2025-03-04 08:00:00+0100 --> 2025-03-10 08:00:00+0100

**serviceProvider**: [Organization MUDr. Jana Krásná](Organization-RegisteringProviderExample.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "10f5c49e-086d-4016-8dd1-b555306bf620",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActPriority",
        "code" : "EM",
        "display" : "emergency"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ADM",
              "display" : "Admitter"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "Practitioner/Practitioner-Admitter"
      }
    },
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "REF",
              "display" : "Referrer"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "PractitionerRole/Practitioner-Referrer-detail"
      }
    }
  ],
  "period" : {
    "start" : "2025-03-01T10:15:00+01:00",
    "end" : "2025-03-10T09:30:00+01:00"
  },
  "reasonReference" : [
    {
      "reference" : "urn:uuid:35717696-8a99-4f99-a938-ec0ec88a65a2"
    }
  ],
  "hospitalization" : {
    "admitSource" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/admit-source",
          "code" : "outp",
          "display" : "From outpatient department"
        }
      ]
    },
    "dischargeDisposition" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/discharge-disposition",
          "code" : "home",
          "display" : "Home"
        }
      ]
    }
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/cz-Location-Chrudim-Chir1"
      },
      "period" : {
        "start" : "2025-03-01T08:00:00+01:00",
        "end" : "2025-03-02T08:00:00+01:00"
      }
    },
    {
      "location" : {
        "reference" : "Location/cz-Location-Chrudim-ChirJIP"
      },
      "period" : {
        "start" : "2025-03-02T08:00:00+01:00",
        "end" : "2025-03-04T08:00:00+01:00"
      }
    },
    {
      "location" : {
        "reference" : "Location/cz-Location-Chrudim-Chir1"
      },
      "period" : {
        "start" : "2025-03-04T08:00:00+01:00",
        "end" : "2025-03-10T08:00:00+01:00"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/RegisteringProviderExample"
  }
}

```
