# Použití kardiostimulátoru - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Použití kardiostimulátoru**

## Example DeviceUseStatement: Použití kardiostimulátoru

Profile: [DeviceUseStatement (HDR)](StructureDefinition-cz-deviceUseStatement-hdr.md)

**status**: Active

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**timing**: 2023-04-10

**device**: [Device: manufacturer = Medtronic; modelNumber = W1DR01; type = Cardiac pacemaker](Device-Device-Pacemaker.md)

**reasonCode**: Heart failure

**reasonReference**: [Bradykardie](Condition-CZ-Condition-HDR-Example.md)

**bodySite**: Thorax



## Resource Content

```json
{
  "resourceType" : "DeviceUseStatement",
  "id" : "DeviceUseStatement-Pacemaker",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr"
    ]
  },
  "status" : "active",
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "timingDateTime" : "2023-04-10",
  "device" : {
    "reference" : "Device/Device-Pacemaker"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/sid/icd-10",
          "code" : "I50",
          "display" : "Heart failure"
        }
      ]
    }
  ],
  "reasonReference" : [
    {
      "reference" : "Condition/CZ-Condition-HDR-Example",
      "display" : "Bradykardie"
    }
  ],
  "bodySite" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "51185008",
        "display" : "Thorax"
      }
    ]
  }
}

```
