# CZ-Condition-HDR Example - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Condition-HDR Example**

## Example Condition: CZ-Condition-HDR Example

Profile: [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Encounter Diagnosis, On admission, Received therapy or drug for

**severity**: Severe

**code**: Heart failure

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**onset**: 2025-01-01 08:00:00+0100

**note**: 

> 

Pacient byl přijat s diagnózou srdečního selhání. Byla zahájena léčba diuretiky a ACE inhibitory.




## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "CZ-Condition-HDR-Example",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "encounter-diagnosis",
          "display" : "Encounter Diagnosis"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "278307001",
          "display" : "On admission"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "69845001",
          "display" : "Received therapy or drug for"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "24484000",
        "display" : "Severe"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "I50",
        "display" : "Heart failure"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "onsetDateTime" : "2025-01-01T08:00:00+01:00",
  "note" : [
    {
      "text" : "Pacient byl přijat s diagnózou srdečního selhání. Byla zahájena léčba diuretiky a ACE inhibitory."
    }
  ]
}

```
