# CZ-Condition-HDR Example 3 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Condition-HDR Example 3**

## Example Condition: CZ-Condition-HDR Example 3

Profile: [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Disease, On admission, Did not receive therapy or drug for

**code**: Postprocedural hypothyroidism

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

**onset**: 1997-10-06 00:00:00+0200

**note**: 

> 

Hypotyreóza po operaci karcinomu štítné žlázy. Zadáno všeobecným lékařem.




## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "CZ-Condition-HDR-Example-3",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "64572001",
          "display" : "Disease"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "278307001",
          "display" : "On admission"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "25265005",
          "display" : "Did not receive therapy or drug for"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "E89.0",
        "display" : "Postprocedural hypothyroidism"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Mracena2"
  },
  "onsetDateTime" : "1997-10-06T00:00:00+02:00",
  "note" : [
    {
      "text" : "Hypotyreóza po operaci karcinomu štítné žlázy. Zadáno všeobecným lékařem."
    }
  ]
}

```
