# eHN Plan of Care Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Plan of Care Model to this guide Map**

## ConceptMap: eHN Plan of Care Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/planOfCare2FHIR-cz-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:PlanOfCare2FHIRCzHdr |

 
eHN HDR Plan of Care Model to this guide Map 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "planOfCare2FHIR-cz-hdr",
  "url" : "https://hl7.cz/fhir/hdr/ConceptMap/planOfCare2FHIR-cz-hdr",
  "version" : "0.1.0",
  "name" : "PlanOfCare2FHIRCzHdr",
  "title" : "eHN Plan of Care Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "eHN HDR Plan of Care Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PlanOfCareCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr",
      "element" : [
        {
          "code" : "PlanOfCare.title",
          "display" : "A.2.9.1.1 - Title",
          "target" : [
            {
              "code" : "CarePlan.title",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PlanOfCare.addresses",
          "display" : "A.2.9.1.2 - Addresses",
          "target" : [
            {
              "code" : "CarePlan.addresses",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PlanOfCare.description",
          "display" : "A.2.9.1.3 - Description",
          "target" : [
            {
              "code" : "CarePlan.description",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PlanOfCare.planPeriod",
          "display" : "A.2.9.1.4 - Plan Period",
          "target" : [
            {
              "code" : "CarePlan.period",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PlanOfCare.details",
          "display" : "A.2.9.1.5 - Other details",
          "target" : [
            {
              "code" : "CarePlan.activity.detail",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PlanOfCare.activity",
          "display" : "A.2.9.1.6 - Activity",
          "target" : [
            {
              "code" : "CarePlan.activity",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PlanOfCare.activity.kind",
          "display" : "A.2.9.1.6.1 - Kind",
          "target" : [
            {
              "code" : "CarePlan.activity.detail.kind",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PlanOfCare.activity.description",
          "display" : "A.2.9.1.6.2 - Activity description",
          "target" : [
            {
              "code" : "CarePlan.detail.description",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PlanOfCare.activity.attribute",
          "display" : "A.2.9.1.6.3 - Specific attributes",
          "target" : [
            {
              "code" : "CarePlan.activity.reference",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    }
  ]
}

```
