# CZ HDR Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ HDR Model to this guide Map**

## ConceptMap: CZ HDR Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/hdr2FHIR-cz-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:Hdr2FHIRCzHdr |

 
CZ Hospital Discharge Report Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "hdr2FHIR-cz-hdr",
  "url" : "https://hl7.cz/fhir/hdr/ConceptMap/hdr2FHIR-cz-hdr",
  "version" : "0.1.0",
  "name" : "Hdr2FHIRCzHdr",
  "title" : "CZ HDR Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Hospital Discharge Report Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/HospitalDischargeReportCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr",
      "element" : [
        {
          "code" : "HospitalDischargeReport.header",
          "display" : "A.1 - Hospital Discharge Report header data element",
          "target" : [
            {
              "code" : "Bundle",
              "equivalence" : "relatedto",
              "comment" : "See the header model and map for details"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/HospitalDischargeReportCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr",
      "element" : [
        {
          "code" : "HospitalDischargeReport.body",
          "display" : "A.2 - Hospital Discharge Report body data element",
          "target" : [
            {
              "code" : "Composition",
              "equivalence" : "relatedto",
              "comment" : "See details below"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.presentedForm",
          "display" : "A.4 - Hospital Discharge Report in its narrative form",
          "target" : [
            {
              "code" : "Composition.extension:relatedArtefact.valueRelatedArtefact.document",
              "equivalence" : "relatedto",
              "comment" : "Attachment (e.g., application/pdf) holding the presented form"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.advanceDirectives",
          "display" : "A.2.1 - Advance directives",
          "target" : [
            {
              "code" : "Composition.section:sectionAdvanceDirectives",
              "equivalence" : "relatedto",
              "comment" : "Advance directives section"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.alerts",
          "display" : "A.2.2 - Alerts",
          "target" : [
            {
              "code" : "Composition.section:sectionAlert",
              "equivalence" : "relatedto",
              "comment" : "See the Alerts model and map for details"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.encounter",
          "display" : "A.2.3 - Encounter",
          "target" : [
            {
              "code" : "Composition.encounter",
              "equivalence" : "relatedto",
              "comment" : "See the InPatientEncounter model and map for details"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.admissionEvaluation",
          "display" : "A.2.4 - Admission evaluation",
          "target" : [
            {
              "code" : "Composition.section:sectionAdmissionEvaluation",
              "equivalence" : "relatedto",
              "comment" : "Admission evaluation (with potential subsections)"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.patientHistory",
          "display" : "A.2.5 - Patient history",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx",
              "equivalence" : "relatedto",
              "comment" : "Narrative patient history section"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.hospitalStay",
          "display" : "A.2.6 - Course of hospitalisation (Hospital stay)",
          "target" : [
            {
              "code" : "Composition.section:sectionHospitalCourse",
              "equivalence" : "relatedto",
              "comment" : "Hospital course narrative + entries"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.dischargeDetails",
          "display" : "A.2.7 - Discharge details",
          "target" : [
            {
              "code" : "Composition.section:sectionDischargeDetails",
              "equivalence" : "relatedto",
              "comment" : "Container for discharge subsections and narrative"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.dischargeDetails.objectiveFindings",
          "display" : "A.2.7.1 - Objective findings",
          "target" : [
            {
              "code" : "Composition.section:sectionDischargeDetails.section:sectionPhysicalExamination",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.dischargeDetails.functionalStatus",
          "display" : "A.2.7.2 - Functional status",
          "target" : [
            {
              "code" : "Composition.section:sectionDischargeDetails.section:sectionFunctionalStatus",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.dischargeDetails.dischargeNote",
          "display" : "A.2.7.3 - Discharge note",
          "target" : [
            {
              "code" : "Composition.section:sectionDischargeDetails",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.recommendations",
          "display" : "A.2.8 - Care plan and other recommendations after discharge.",
          "target" : [
            {
              "code" : "Composition.section",
              "equivalence" : "relatedto",
              "comment" : "Potentially covered by several sections"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.recommendations.carePlan",
          "display" : "A.2.8.1 - Care plan",
          "target" : [
            {
              "code" : "Composition.section:sectionPlanOfCare",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.recommendations.medicationSummary",
          "display" : "A.2.8.2 - Medication summary",
          "target" : [
            {
              "code" : "Composition.section:sectionPharmacotherapy",
              "equivalence" : "relatedto",
              "comment" : "CZ guide uses Pharmacotherapy section; use Discharge Medications if present in jurisdiction"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.body.recommendations.otherRecommendations",
          "display" : "A.2.8.3 - Other recommendations",
          "target" : [
            {
              "code" : "Composition.section:sectionDischargeInstructions",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    }
  ]
}

```
