# Temporary HDR Code System - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Temporary HDR Code System**

## CodeSystem: Temporary HDR Code System (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/CodeSystem/temporarySystem-hdr-cz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:TemporaryHDRSystem |

 
This is a temporary code system defined to collect concepts expected required by this project, but for which international coded concepts have not been identified yet. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "temporarySystem-hdr-cz",
  "url" : "https://hl7.cz/fhir/hdr/CodeSystem/temporarySystem-hdr-cz",
  "version" : "0.1.0",
  "name" : "TemporaryHDRSystem",
  "title" : "Temporary HDR Code System",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This is a temporary code system defined to collect concepts expected required by this project, but for which international coded concepts have not been identified yet.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "infection-contact",
      "display" : "Infectious contacts",
      "definition" : "Infectious contacts Section"
    },
    {
      "code" : "anthropometry",
      "display" : "Anthropometry Section",
      "definition" : "Anthropometry Section"
    },
    {
      "code" : "substance-use",
      "display" : "Use of Substances Section",
      "definition" : "Use of Substances Section"
    }
  ]
}

```
