# AllergyIntolerance - Strawberry - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **AllergyIntolerance - Strawberry**

## Example AllergyIntolerance: AllergyIntolerance - Strawberry

Profile: [Allergy Intolerance (HDR CZ)](StructureDefinition-cz-allergyIntolerance-hdr.md)

**identifier**: `urn:oid:1.2.203.24341.1.1.999`/Allergy-Strawberry-Novak-001

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**type**: Allergy

**category**: Food

**criticality**: Low Risk

**code**: Strawberry

**patient**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**onset**: 2020-01-01

**recordedDate**: 2023-10-01

> **reaction****manifestation**:Edema of the tongue,Bronchospasm**onset**: 2020-01-01 12:00:00+0000

> **reaction****manifestation**:Itching of skin**onset**: 2022-10-01 10:00:00+0000**severity**: Mild



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "6cf80cb1-9766-470f-ac36-b1d3d8950f1b",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:oid:1.2.203.24341.1.1.999",
      "value" : "Allergy-Strawberry-Novak-001"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed"
      }
    ]
  },
  "type" : "allergy",
  "category" : ["food"],
  "criticality" : "low",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "102261002",
        "display" : "Strawberry"
      }
    ]
  },
  "patient" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "onsetDateTime" : "2020-01-01",
  "recordedDate" : "2023-10-01",
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "81950002",
              "display" : "Edema of the tongue"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "4386001",
              "display" : "Bronchospasm"
            }
          ]
        }
      ],
      "onset" : "2020-01-01T12:00:00Z"
    },
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "418363000",
              "display" : "Itching of skin"
            }
          ]
        }
      ],
      "onset" : "2022-10-01T10:00:00Z",
      "severity" : "mild"
    }
  ]
}

```
