# Related Person Relationship Types (HDR) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Related Person Relationship Types (HDR)**

## ValueSet: Related Person Relationship Types (HDR) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ValueSet/relatedPersonRelationshipTypes-eu-hdr | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:RelatedPersonRelationshipTypesHDR |

 
HDR related person relationship types value set. 

 **References** 

* [Related Person: HDR (CZ)](StructureDefinition-cz-relatedPerson-hdr.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "relatedPersonRelationshipTypes-eu-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/ValueSet/relatedPersonRelationshipTypes-eu-hdr",
  "version" : "0.1.0",
  "name" : "RelatedPersonRelationshipTypesHDR",
  "title" : "Related Person Relationship Types (HDR)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "HDR related person relationship types value set.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
        "concept" : [
          {
            "code" : "ECON",
            "display" : "Emergency contact"
          },
          {
            "code" : "NOK",
            "display" : "Next of kin"
          },
          {
            "code" : "GUARD",
            "display" : "Guardian"
          },
          {
            "code" : "PRS",
            "display" : "Personal relationship"
          },
          {
            "code" : "CAREGIVER",
            "display" : "Caregiver"
          }
        ]
      }
    ]
  }
}

```
