# Procedure (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Procedure (HDR CZ)**

## Resource Profile: Procedure (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ProcedureHdr |

 
This profile represents the constraints applied to the Procedure resource by this guide. 

**Usages:**

* Derived from this Profile: [Procedure: Obligations](StructureDefinition-cz-procedure-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Procedure/CZ-Procedure-HDR-Example-Acute-appendicitis](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md), [Procedure/ColonoscopyProcedure](Procedure-ColonoscopyProcedure.md), [Procedure/Procedure-Appendectomy](Procedure-Procedure-Appendectomy.md), [Procedure/Procedure-Insert-Pacemaker](Procedure-Procedure-Insert-Pacemaker.md)...Show 3 more,[Procedure/Procedure-Insert-Pacemaker2](Procedure-Procedure-Insert-Pacemaker2.md),[Procedure/Procedure-No-Procedure](Procedure-Procedure-No-Procedure.md)and[Procedure/ffb1a62f-9050-4e33-af4b-4cdb8203c9e5](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-procedure-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-procedure-hdr.csv), [Excel](StructureDefinition-cz-procedure-hdr.xlsx), [Schematron](StructureDefinition-cz-procedure-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-procedure-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/procedure-eu-hdr"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr",
  "version" : "0.1.0",
  "name" : "CZ_ProcedureHdr",
  "title" : "Procedure (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the Procedure resource by this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure.text",
        "path" : "Procedure.text",
        "min" : 1
      },
      {
        "id" : "Procedure.extension",
        "path" : "Procedure.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.extension:bodySite",
        "path" : "Procedure.extension",
        "sliceName" : "bodySite",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.extension:bodySite.value[x]",
        "path" : "Procedure.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/laboratory/StructureDefinition/BodyStructure-eu-lab"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "definition" : "Identification of the procedure or recording of \"absence of relevant procedures\" or of \"procedures unknown\".",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/uv/ips/ValueSet/procedures-uv-ips|2.0.0"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Codes for procedures in IPS"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/procedures-snomed-absent-unknown-eu-hdr"
        }
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.subject.reference",
        "path" : "Procedure.subject.reference",
        "min" : 1
      },
      {
        "id" : "Procedure.performed[x]",
        "path" : "Procedure.performed[x]",
        "min" : 1
      },
      {
        "id" : "Procedure.performed[x].extension:data-absent-reason",
        "path" : "Procedure.performed[x].extension",
        "sliceName" : "data-absent-reason",
        "short" : "performed[x] absence reason",
        "definition" : "Provides a reason why the performed is missing.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer.actor",
        "path" : "Procedure.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer.onBehalfOf",
        "path" : "Procedure.performer.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.reasonCode",
        "path" : "Procedure.reasonCode",
        "short" : "Why the procedure was performed (code)"
      },
      {
        "id" : "Procedure.reasonReference",
        "path" : "Procedure.reasonReference",
        "short" : "Why the procedure was performed (details)"
      },
      {
        "id" : "Procedure.bodySite",
        "path" : "Procedure.bodySite",
        "definition" : "Anatomical location which is the focus of the problem.",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Procedure.outcome",
        "path" : "Procedure.outcome",
        "short" : "Outcome of the procedure"
      },
      {
        "id" : "Procedure.complication",
        "path" : "Procedure.complication",
        "short" : "Complications that occurred during the procedure (code)"
      },
      {
        "id" : "Procedure.complicationDetail",
        "path" : "Procedure.complicationDetail",
        "short" : "Complications that occurred during the procedure (details)"
      },
      {
        "id" : "Procedure.focalDevice",
        "path" : "Procedure.focalDevice",
        "short" : "Device implanted, removed or otherwise manipulated"
      },
      {
        "id" : "Procedure.focalDevice.manipulated",
        "path" : "Procedure.focalDevice.manipulated",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      }
    ]
  }
}

```
