# ImmunizationRecommendation (CZ HDR) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ImmunizationRecommendation (CZ HDR)**

## Resource Profile: ImmunizationRecommendation (CZ HDR) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ImmunizationRecommendationHdr |

 
This profile defines how to represent Immunization Recommandations for the purpose of this guide. 

**Usages:**

* Derived from this Profile: [Immunization Recommendation Obligations (HDR CZ)](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md)
* Refer to this Profile: [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md)
* Examples for this Profile: [ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-immunizationRecommendation-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-immunizationRecommendation-hdr.csv), [Excel](StructureDefinition-cz-immunizationRecommendation-hdr.xlsx), [Schematron](StructureDefinition-cz-immunizationRecommendation-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-immunizationRecommendation-hdr",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr",
  "version" : "0.1.0",
  "name" : "CZ_ImmunizationRecommendationHdr",
  "title" : "ImmunizationRecommendation (CZ HDR)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Immunization Recommandations for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ImmunizationRecommendation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ImmunizationRecommendation",
        "path" : "ImmunizationRecommendation"
      },
      {
        "id" : "ImmunizationRecommendation.patient",
        "path" : "ImmunizationRecommendation.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "ImmunizationRecommendation.date",
        "path" : "ImmunizationRecommendation.date",
        "short" : "When recomendation was created"
      },
      {
        "id" : "ImmunizationRecommendation.recommendation",
        "path" : "ImmunizationRecommendation.recommendation",
        "short" : "Generic description of the vaccine/prophylaxis or its component(s)"
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.vaccineCode",
        "path" : "ImmunizationRecommendation.recommendation.vaccineCode",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-whoatc-uv-ips|2.0.0"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Additional conformance binding to a vaccines value set from the WHO ATC code system for use in specific jurisdictional or other contexts where use of the ATC terminology is preferred."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "For when WHO ATC code system is preferred"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "The type of vaccine for particular disease or diseases against which the patient has been immunised, or a code for absent/unknown immunization.",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-uv-ips|2.0.0"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.targetDisease",
        "path" : "ImmunizationRecommendation.recommendation.targetDisease",
        "short" : "Disease or agent that the vaccination provides protection against",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/condition-eu-hdr"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.forecastStatus",
        "path" : "ImmunizationRecommendation.recommendation.forecastStatus",
        "short" : "Recommendation status"
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.dateCriterion",
        "path" : "ImmunizationRecommendation.recommendation.dateCriterion",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.dateCriterion:nextDose",
        "path" : "ImmunizationRecommendation.recommendation.dateCriterion",
        "sliceName" : "nextDose",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.dateCriterion:nextDose.code",
        "path" : "ImmunizationRecommendation.recommendation.dateCriterion.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "30980-7"
            }
          ]
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.doseNumber[x]",
        "path" : "ImmunizationRecommendation.recommendation.doseNumber[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.doseNumber[x]:doseNumberPositiveInt",
        "path" : "ImmunizationRecommendation.recommendation.doseNumber[x]",
        "sliceName" : "doseNumberPositiveInt",
        "short" : "Dose Number",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.seriesDoses[x]",
        "path" : "ImmunizationRecommendation.recommendation.seriesDoses[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.seriesDoses[x]:seriesDosesPositiveInt",
        "path" : "ImmunizationRecommendation.recommendation.seriesDoses[x]",
        "sliceName" : "seriesDosesPositiveInt",
        "short" : "Number of doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      }
    ]
  }
}

```
